/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.reporting;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.clients.registration.exceptions.RegistrationException;
import com.microsoft.tfs.core.clients.reporting.Report;
import com.microsoft.tfs.core.clients.reporting.ReportFolder;
import com.microsoft.tfs.core.clients.reporting.ReportNode;
import com.microsoft.tfs.core.ws.runtime.client.SOAPService;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ms.sql.reporting.reportingservices._CatalogItem;
import ms.sql.reporting.reportingservices._ReportingService2005Soap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportingClient {
    private static final Log log = LogFactory.getLog(ReportingClient.class);
    private final _ReportingService2005Soap webService;
    private final TFSTeamProjectCollection connection;
    private boolean is2010Server = false;

    public ReportingClient(TFSTeamProjectCollection connection, _ReportingService2005Soap webService) {
        this.connection = connection;
        this.webService = webService;
    }

    public _ReportingService2005Soap getProxy() {
        return this.webService;
    }

    public String getFixedURI(String uri) {
        Check.notNull(uri, "uri");
        try {
            String url = this.connection.getRegistrationClient().getServiceInterfaceURL("Reports", "ReportsService");
            if (url == null || url.length() == 0) {
                url = this.connection.getRegistrationClient().getServiceInterfaceURL("Reports", "ReportWebServiceUrl");
                if (url == null || url.length() == 0) {
                    return uri;
                }
                this.is2010Server = true;
            }
            URI registeredEndpointUri = new URI(url);
            URI passedUri = new URI(uri);
            if (passedUri.getScheme().equals(registeredEndpointUri.getScheme()) && passedUri.getHost().equals(registeredEndpointUri.getHost()) && passedUri.getPort() == registeredEndpointUri.getPort()) {
                URI endpointUri = ((SOAPService)((Object)this.getProxy())).getEndpoint();
                URI fixedUri = new URI(endpointUri.getScheme(), endpointUri.getHost(), passedUri.getPath(), passedUri.getQuery(), passedUri.getFragment());
                return fixedUri.toASCIIString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }

    public List getReports(ProjectInfo projectInfo, boolean refresh) {
        String item = this.getFullItemPath(projectInfo);
        _CatalogItem[] items = this.getProxy().listChildren(item, true);
        if (items == null) {
            return new ArrayList(0);
        }
        ReportFolder root = this.populateChildren(projectInfo.getName(), new ReportFolder(projectInfo.getName(), item + "/"), items, false);
        return Arrays.asList(root.getChildren());
    }

    private ReportFolder populateChildren(String projectName, ReportFolder parentNode, _CatalogItem[] items, boolean showHidden) {
        parentNode = this.populateChildren(projectName, parentNode, items, "Folder", showHidden);
        Object[] subFolders = parentNode.getChildren();
        for (int i = 0; i < subFolders.length; ++i) {
            subFolders[i] = this.populateChildren(projectName, (ReportFolder)subFolders[i], items, showHidden);
        }
        parentNode = this.populateChildren(projectName, parentNode, items, "Report", showHidden);
        return parentNode;
    }

    private ReportFolder populateChildren(String projectName, ReportFolder parentNode, _CatalogItem[] items, String type, boolean showHidden) {
        for (int i = 0; i < items.length; ++i) {
            if (!this.isChildPath(parentNode.getPath(), items[i].getPath()) || !type.equals(items[i].getType().toString()) || !showHidden && items[i].isHidden()) continue;
            ReportNode node = items[i].getType().toString().equals("Folder") ? new ReportFolder(projectName, items[i]) : new Report(projectName, items[i]);
            node.setParent(parentNode);
            parentNode.addChild(node);
        }
        return parentNode;
    }

    public boolean isChildPath(String parentPath, String evalPath) {
        String subPath;
        if (parentPath == null || evalPath == null || evalPath.length() < parentPath.length()) {
            return false;
        }
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        return (subPath = evalPath.substring(0, Math.min(evalPath.length(), parentPath.length()))).equalsIgnoreCase(parentPath) && evalPath.indexOf(47, parentPath.length()) < 0;
    }

    private String getFullItemPath(ProjectInfo projectInfo) {
        String itemPath = null;
        ProjectCollectionEntity projectCollection = this.connection.getTeamProjectCollectionEntity(false);
        if (projectCollection != null) {
            TeamProjectEntity project = projectCollection.getTeamProject(new GUID(projectInfo.getGUID()));
            if (project == null) {
                log.warn((Object)MessageFormat.format("Could not locate project catalog data for {0}", projectInfo.getGUID()));
            } else {
                ReportingFolderEntity collectionReportingFolder = projectCollection.getReportingFolder();
                ReportingFolderEntity projectReportingFolder = project.getReportingFolder();
                if (collectionReportingFolder == null || projectReportingFolder == null) {
                    log.info((Object)"Could not locate project reporting folder catalog data");
                } else {
                    itemPath = MessageFormat.format("{0}/{1}", collectionReportingFolder.getItemPath(), projectReportingFolder.getItemPath());
                }
            }
        } else {
            if (this.is2010Server && (itemPath = this.connection.getRegistrationClient().getRosarioURLForTeamProject("ReportFolder", projectInfo.getName())) == null) {
                throw new RegistrationException("Unable to determine report folder for TFS 2010 server. Possibly a pre TFS 2010 Beta 2 instance?");
            }
            if (itemPath == null || itemPath.length() == 0) {
                itemPath = "/" + projectInfo.getName();
            }
        }
        return itemPath;
    }

    protected boolean isTFS2010Server() {
        return this.is2010Server;
    }
}

