/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem;

import com.microsoft.tfs.core.clients.workitem.WorkItemServerVersion;
import com.microsoft.tfs.util.Check;
import java.util.HashSet;
import java.util.Set;

public final class ServerInfo {
    private final Set<String> features = new HashSet<String>();

    public ServerInfo(WorkItemServerVersion version) {
        Check.notNull(version, "version");
        if (version.getValue() >= WorkItemServerVersion.V2.getValue()) {
            this.features.add("WorkItemLinks");
            this.features.add("QueryFolders");
            this.features.add("QueryInGroup");
        }
        if (version.getValue() >= WorkItemServerVersion.V3.getValue()) {
            this.features.add("GuidFields");
            this.features.add("BooleanFields");
            this.features.add("QueryFolders");
            this.features.add("QueryFolderPermissions");
            this.features.add("QueryFolderSetOwner");
            this.features.add("QueryFieldsComparison");
            this.features.add("QueryHistoricalRevisions");
            this.features.add("WorkItemTypeCategories");
            this.features.add("WorkItemTypeCategoryMembers");
            this.features.add("WorkItemLinks");
            this.features.add("WorkItemLinkLocks");
            this.features.add("QueryInGroup");
            this.features.add("BatchSaveWorkItemsFromDifferentProjects");
            this.features.add("SyncNameChanges");
            this.features.add("ReportingNames");
            this.features.add("SetReportingTypeToNone");
        }
        if (version.getValue() >= WorkItemServerVersion.V5.getValue()) {
            this.features.add("QueryRecursiveReturnMatchingChildren");
            this.features.add("ProvisionPermission");
            this.features.add("ConfigurableBulkUpdateBatchSize");
        }
        if (version.getValue() >= WorkItemServerVersion.V8.getValue()) {
            this.features.add("WiqlEvaluationOnServer");
        }
    }

    public boolean isSupported(String feature) {
        Check.notNull(feature, "feature");
        return this.features.contains(feature);
    }
}

