/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata;

import com.microsoft.tfs.core.clients.workitem.internal.rules.Rule;
import java.text.MessageFormat;

public class SpecialConstantIDs {
    public static final int SPECIAL_CONSTANT_IDS_START_RANGE = -20000;
    public static final int SPECIAL_CONSTANT_IDS_END_RANGE = -10000;
    public static final int CONST_VALID_USER = -2;
    public static final int CONST_EMPTY_VALUE = -10000;
    public static final int CONST_SAME_AS_OLD_VALUE = -10001;
    public static final int CONST_CURRENT_USER = -10002;
    public static final int CONST_OLD_VALUE_PLUS_ONE = -10003;
    public static final int CONST_WAS_EMPTY_VALUE = -10006;
    public static final int CONST_OLD_VALUE_IN_OTHER_FIELD = -10012;
    public static final int CONST_SERVER_DATE_TIME = -10013;
    public static final int CONST_BECAME_NON_EMPTY_VALUE = -10014;
    public static final int CONST_REMAINED_NON_EMPTY_VALUE = -10015;
    public static final int CONST_DELETED_TREE_LOCATION = -10016;
    public static final int CONST_ADMIN_ONLY_TREE_LOCATION = -10017;
    public static final int CONST_AFTER_SERVER_TIME = -10019;
    public static final int CONST_WAS_EMPTY_OR_SAME_AS_OLD_VALUE = -10022;
    public static final int CONST_VALUE_IN_OTHER_FIELD = -10025;
    public static final int CONST_SERVER_CURRENT_USER = -10026;
    public static final int CONST_LOCAL_DATE_TIME = -10027;
    public static final int CONST_UTC_DATE_TIME = -10028;
    public static final int CONST_IS_EMPTY_OR_SAME_AS_OLD_VALUE = -10029;
    public static final int CONST_GREATER_THAN_OLD_VALUE = -10030;
    public static final int CONST_SERVER_RANDOM_GUID = -10031;
    public static final int CONST_NOT_GREATER_THAN_SERVER_TIME = -10032;

    public static boolean isSpecialConstantID(int id) {
        return id >= -20000 && id <= -10000;
    }

    public static final String makeErrorMessage(int constantId, Rule rule, String subMessage) {
        return MessageFormat.format("unhandled special constant [{0}] ({1}) for \"{2}\" (rule {3})", Integer.toString(constantId), SpecialConstantIDs.getSpecialConstantString(constantId), subMessage, Integer.toString(rule.getRuleID()));
    }

    public static final String getSpecialConstantString(int id) {
        switch (id) {
            case -2: {
                return "ConstValidUser";
            }
            case -10000: {
                return "ConstEmptyValue";
            }
            case -10001: {
                return "ConstSameAsOldValue";
            }
            case -10002: {
                return "ConstCurrentUser";
            }
            case -10006: {
                return "ConstWasEmptyValue";
            }
            case -10012: {
                return "ConstOldValueInOtherField";
            }
            case -10013: {
                return "ConstServerDateTime";
            }
            case -10028: {
                return "ConstUtcDateTime";
            }
            case -10026: {
                return "ConstServerCurrentUser";
            }
            case -10027: {
                return "ConstLocalDateTime";
            }
            case -10015: {
                return "ConstRemainedNonEmptyValue";
            }
            case -10019: {
                return "ConstAfterServerTime";
            }
            case -10025: {
                return "ConstValueInOtherField";
            }
            case -10029: {
                return "ConstIsEmptyOrSameAsOldValue";
            }
            case -10022: {
                return "ConstWasEmptyOrSameAsOldValue";
            }
            case -10014: {
                return "ConstBecameNonEmptyValue";
            }
            case -10003: {
                return "ConstOldValuePlusOne";
            }
            case -10030: {
                return "ConstGreaterThanOldValue";
            }
            case -10016: {
                return "ConstDeletedTreeLocation";
            }
            case -10017: {
                return "ConstAdminOnlyTreeLocation";
            }
            case -10032: {
                return "ConstNotGreaterThanServerTime";
            }
        }
        return "Unknown Special Constant";
    }
}

