/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityHelper;
import com.microsoft.tfs.core.clients.workitem.exceptions.QueryHierarchyException;
import com.microsoft.tfs.core.clients.workitem.exceptions.UnauthorizedAccessException;
import com.microsoft.tfs.core.clients.workitem.exceptions.ValidationException;
import com.microsoft.tfs.core.clients.workitem.internal.project.ProjectImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryBucket;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryProviderImpl;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryFolderImpl;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.GetStoredQueryItemRowSet;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.GetStoredQueryItemsRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParser;
import com.microsoft.tfs.core.clients.workitem.internal.update.QueryHierarchyBatchUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.query.QueryScope;
import com.microsoft.tfs.core.clients.workitem.query.StoredQuery;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryHierarchy;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.exceptions.mappers.WorkItemExceptionMapper;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class QueryHierarchyImpl
extends QueryFolderImpl
implements QueryHierarchy {
    public static final String PRIVATE_QUERY_FOLDER_NAME = Messages.getString("QueryHierarchy.PrivateQueryFolderDisplayName");
    public static final String PUBLIC_QUERY_FOLDER_NAME = Messages.getString("QueryHierarchy.PublicQueryFolderDisplayName");
    private static final boolean incrementalRefresh = false;
    private long rowVersion;

    public QueryHierarchyImpl(Project project) {
        super(project.getName(), null, GUID.EMPTY, null);
        this.setID(GUID.EMPTY);
        this.setProject(project);
        this.updateQueries(false);
    }

    @Override
    public boolean supportsFolders() {
        return this.getQueryHierarchyProvider().supportsFolders();
    }

    @Override
    public boolean supportsPermissions() {
        return this.getQueryHierarchyProvider().supportsPermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryItem find(final GUID id) {
        Check.notNull(id, "id");
        final Object itemLock = new Object();
        final QueryItem[] item = new QueryItem[1];
        this.runWithLock(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = itemLock;
                synchronized (object) {
                    item[0] = QueryHierarchyImpl.this.findInternal(QueryHierarchyImpl.this, id);
                }
            }
        });
        Object object = itemLock;
        synchronized (object) {
            return item[0];
        }
    }

    private QueryItem findInternal(QueryFolder root, GUID id) {
        QueryItem[] items = root.getItems();
        for (int i = 0; i < items.length; ++i) {
            QueryItem item;
            if (items[i].getID().equals(id)) {
                return items[i];
            }
            if (!(items[i] instanceof QueryFolder) || (item = this.findInternal((QueryFolder)items[i], id)) == null) continue;
            return item;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.runWithLock(new Runnable(){

            @Override
            public void run() {
                QueryHierarchyImpl.this.resetInternal();
                QueryHierarchyImpl.this.updateQueries(true);
            }
        });
        this.fireHierarchyRefreshedEvent();
    }

    private void updateQueries(boolean refresh) {
        HashMap<GUID, QueryItem> existingQueryItemsByGuid = new HashMap<GUID, QueryItem>();
        this.populateGUIDDictionary(this, existingQueryItemsByGuid);
        if (this.supportsFolders()) {
            try {
                long rowVersion = 0L;
                HashMap<GUID, QueryItem> unmatchedItems = new HashMap<GUID, QueryItem>(existingQueryItemsByGuid);
                DOMAnyContentType payload = (DOMAnyContentType)this.getProject().getWITContext().getProxy3().getStoredQueryItems(rowVersion, this.getProject().getID(), new DOMAnyContentType());
                Element[] payloadElements = payload.getElements();
                for (int i = 0; i < payloadElements.length; ++i) {
                    RowSetParser parser = new RowSetParser();
                    GetStoredQueryItemsRowSetHandler handler = new GetStoredQueryItemsRowSetHandler();
                    parser.parse(payloadElements[i], (RowSetParseHandler)handler);
                    this.processQueries(refresh, existingQueryItemsByGuid, unmatchedItems, handler.getRowSets(), i == 0);
                }
                boolean supportsPermissions = this.getProject().getWITContext().getQueryHierarchyProvider().supportsPermissions();
                if (refresh && supportsPermissions) {
                    for (QueryItem item : unmatchedItems.values()) {
                        if (item == null || item instanceof QueryFolderImpl && ((QueryFolderImpl)item).isRootNode()) continue;
                        if (item.getParent() instanceof QueryFolderImpl) {
                            ((QueryFolderImpl)item.getParent()).deleteInternal(item, false);
                        }
                        if (!(item instanceof QueryItemImpl)) continue;
                        ((QueryItemImpl)item).setDeleted(true);
                    }
                }
                return;
            }
            catch (RuntimeException e) {
                throw WorkItemExceptionMapper.map(e);
            }
        }
        this.updateQueriesFromOldServer(refresh);
    }

    private QueryFolder processQueries(boolean isRefresh, Map<GUID, QueryItem> existingItemsByGuid, Map<GUID, QueryItem> unmatchedItems, GetStoredQueryItemRowSet[] storedQueryItemsRowSets, boolean isPublic) {
        QueryHierarchyImpl folder = this;
        HashMap<GUID, List<QueryItem>> waitingForParentList = new HashMap<GUID, List<QueryItem>>();
        boolean supportsPermissions = this.getProject().getWITContext().getQueryHierarchyProvider().supportsPermissions();
        for (int i = 0; i < storedQueryItemsRowSets.length; ++i) {
            GUID parentId;
            GetStoredQueryItemRowSet itemRowSet = storedQueryItemsRowSets[i];
            IdentityDescriptor ownerDescriptor = null;
            if (supportsPermissions && itemRowSet.getOwnerIdentifier() != null && itemRowSet.getOwnerIdentifier() != null) {
                ownerDescriptor = new IdentityDescriptor(itemRowSet.getOwnerType(), itemRowSet.getOwnerIdentifier());
            }
            GUID id = new GUID(itemRowSet.getID());
            String name = itemRowSet.getName();
            if (itemRowSet.getParentID() != null && !itemRowSet.getParentID().equals("")) {
                parentId = new GUID(itemRowSet.getParentID());
            } else {
                parentId = GUID.EMPTY;
                if (itemRowSet.getName().equals("")) {
                    String string = name = isPublic ? PUBLIC_QUERY_FOLDER_NAME : PRIVATE_QUERY_FOLDER_NAME;
                }
            }
            if (itemRowSet.getCacheStamp() > this.rowVersion) {
                this.rowVersion = itemRowSet.getCacheStamp();
            }
            QueryItem item = null;
            if (existingItemsByGuid.containsKey(id)) {
                item = existingItemsByGuid.get(id);
                unmatchedItems.remove(id);
            }
            if (itemRowSet.isDeleted()) {
                if (item == null) continue;
                if (item.getParent() instanceof QueryFolderImpl) {
                    ((QueryFolderImpl)item.getParent()).deleteInternal(item, false);
                }
                if (!(item instanceof QueryItemImpl)) continue;
                ((QueryItemImpl)item).setDeleted(true);
                continue;
            }
            this.addUpdateItem(name, id, parentId, item, itemRowSet.getText(), itemRowSet.isFolder(), isPublic, ownerDescriptor, existingItemsByGuid, waitingForParentList);
        }
        return folder;
    }

    private void addUpdateItem(String name, GUID id, GUID parentId, QueryItem existingItem, String queryText, boolean isFolder, boolean isPublic, IdentityDescriptor ownerDescriptor, Map<GUID, QueryItem> existingItemsByGuid, Map<GUID, List<QueryItem>> waitingForParentList) {
        QueryItem item;
        QueryFolder parent = null;
        if (existingItemsByGuid.containsKey(parentId)) {
            parent = (QueryFolder)existingItemsByGuid.get(parentId);
        }
        if (existingItem == null) {
            item = isFolder ? this.createFolder(name, parent, id, isPublic, ownerDescriptor, waitingForParentList, existingItemsByGuid) : new QueryDefinitionImpl(name, queryText, parent, id, ownerDescriptor);
        } else {
            item = existingItem;
            if (parent != null && !parent.containsID(existingItem.getID()) && parent instanceof QueryFolderImpl) {
                ((QueryFolderImpl)parent).addInternal(existingItem, false);
            }
            if (!existingItem.getName().equals(name)) {
                if (parent != null && parent instanceof QueryFolderImpl) {
                    ((QueryFolderImpl)parent).updateName(existingItem, name);
                } else {
                    existingItem.setName(name);
                }
            }
            existingItem.setOwnerDescriptor(ownerDescriptor);
            if (!isFolder && existingItem instanceof QueryDefinitionImpl) {
                ((QueryDefinitionImpl)existingItem).setQueryTextProtected(queryText);
            }
            if (item instanceof QueryItemImpl) {
                ((QueryItemImpl)item).resetDirty();
            }
        }
        if (parent == null) {
            List<Object> waitingList;
            if (!waitingForParentList.containsKey(parentId)) {
                waitingList = new ArrayList();
                waitingForParentList.put(parentId, waitingList);
            } else {
                waitingList = waitingForParentList.get(parentId);
            }
            waitingList.add(item);
        }
    }

    private QueryFolder createFolder(String name, QueryFolder parent, GUID id, boolean isPublic, IdentityDescriptor ownerDescriptor, Map<GUID, List<QueryItem>> waitingForParentList, Map<GUID, QueryItem> existingItemsByGuid) {
        QueryFolderImpl folder = new QueryFolderImpl(name, parent, id, ownerDescriptor);
        folder.setProject(this.getProject());
        folder.setPersonal(!isPublic);
        existingItemsByGuid.put(id, folder);
        if (waitingForParentList.containsKey(id)) {
            List<QueryItem> waitingList = waitingForParentList.get(id);
            for (QueryItem item : waitingList) {
                folder.addInternal(item, false);
                if (!(item instanceof QueryItemImpl)) continue;
                ((QueryItemImpl)item).resetDirty();
            }
            waitingForParentList.remove(id);
        }
        return folder;
    }

    private void populateGUIDDictionary(QueryFolder folder, Map<GUID, QueryItem> existingQueryItemsByGuid) {
        existingQueryItemsByGuid.put(folder.getID(), folder);
        QueryItem[] folderItems = folder.getItems();
        for (int i = 0; i < folderItems.length; ++i) {
            if (folderItems[i] instanceof QueryFolder) {
                this.populateGUIDDictionary((QueryFolder)folderItems[i], existingQueryItemsByGuid);
                continue;
            }
            existingQueryItemsByGuid.put(folderItems[i].getID(), folderItems[i]);
        }
    }

    private void updateQueriesFromOldServer(boolean refresh) {
        QueryFolderImpl publicFolder;
        QueryFolderImpl privateFolder;
        if (!this.containsName(PRIVATE_QUERY_FOLDER_NAME)) {
            privateFolder = new QueryFolderImpl(PRIVATE_QUERY_FOLDER_NAME, this, GUID.newGUID(), null);
            privateFolder.setPersonal(true);
        } else {
            privateFolder = (QueryFolderImpl)this.getItemByName(PRIVATE_QUERY_FOLDER_NAME);
        }
        if (!this.containsName(PUBLIC_QUERY_FOLDER_NAME)) {
            publicFolder = new QueryFolderImpl(PUBLIC_QUERY_FOLDER_NAME, this, GUID.newGUID(), null);
            publicFolder.setPersonal(false);
        } else {
            publicFolder = (QueryFolderImpl)this.getItemByName(PUBLIC_QUERY_FOLDER_NAME);
        }
        HashMap<GUID, QueryItem> existingQueryItemsByGuid = new HashMap<GUID, QueryItem>();
        HashMap<GUID, List<QueryItem>> waitingForParentList = new HashMap<GUID, List<QueryItem>>();
        this.populateGUIDDictionary(this, existingQueryItemsByGuid);
        StoredQueryBucket queryBucket = this.getProject().getWITContext().getQueryProvider().getQueryBucket(this.getProject().getID());
        if (refresh) {
            queryBucket.refresh();
        }
        HashMap<GUID, StoredQuery> storedQueryMap = new HashMap<GUID, StoredQuery>();
        for (StoredQuery query : queryBucket.getQueryList()) {
            storedQueryMap.put(query.getQueryGUID(), query);
            QueryFolderImpl parent = query.getQueryScope().equals(QueryScope.PRIVATE) ? privateFolder : publicFolder;
            QueryItem existingItem = null;
            if (publicFolder.containsID(query.getQueryGUID())) {
                existingItem = publicFolder.getItemByID(query.getQueryGUID());
            } else if (privateFolder.containsID(query.getQueryGUID())) {
                existingItem = privateFolder.getItemByID(query.getQueryGUID());
            }
            this.addUpdateItem(query.getName(), query.getQueryGUID(), parent.getID(), existingItem, query.getQueryText(), false, query.getQueryScope() == QueryScope.PUBLIC, null, existingQueryItemsByGuid, waitingForParentList);
        }
        for (QueryItem item : existingQueryItemsByGuid.values()) {
            if (storedQueryMap.containsKey(item.getID()) || !(item instanceof QueryDefinition)) continue;
            if (item.getParent() instanceof QueryFolderImpl) {
                ((QueryFolderImpl)item.getParent()).deleteInternal(item, false);
            }
            if (!(item instanceof QueryItemImpl)) continue;
            ((QueryItemImpl)item).setDeleted(true);
        }
    }

    @Override
    public void reset() {
        this.runWithLock(new Runnable(){

            @Override
            public void run() {
                QueryHierarchyImpl.this.resetInternal();
            }
        });
        this.fireHierarchyResetEvent();
    }

    @Override
    public void save() {
        this.runWithLock(new Runnable(){

            @Override
            public void run() {
                QueryHierarchyImpl.this.validate(QueryHierarchyImpl.this.getProject().getWITContext());
                if (QueryHierarchyImpl.this.supportsFolders()) {
                    QueryHierarchyImpl.this.saveToNewServer();
                } else {
                    QueryHierarchyImpl.this.saveToOldServer();
                }
            }
        });
    }

    private void saveToNewServer() {
        ArrayList<QueryItem> itemsToSave = new ArrayList<QueryItem>();
        this.getDirtyItems(this, itemsToSave);
        if (itemsToSave.size() != 0) {
            this.saveQueryItems(itemsToSave);
            this.saveCompleted(itemsToSave);
        }
    }

    private void getDirtyItems(QueryItem item, List<QueryItem> itemsToSave) {
        if (!(!item.isDirty() || item.isNew() && item.isDeleted())) {
            itemsToSave.add(item);
        }
        if (item instanceof QueryFolder) {
            QueryItem[] removedItems;
            QueryFolder folder = (QueryFolder)item;
            QueryItem[] queryItemArray = removedItems = folder instanceof QueryFolderImpl ? ((QueryFolderImpl)folder).getRemovedItems() : null;
            if (!folder.isDeleted() && removedItems != null) {
                for (int i = 0; i < removedItems.length; ++i) {
                    if (!removedItems[i].isDeleted() || removedItems[i].isNew()) continue;
                    itemsToSave.add(removedItems[i]);
                }
            }
            QueryItem[] children = folder.getItems();
            for (int i = 0; i < children.length; ++i) {
                this.getDirtyItems(children[i], itemsToSave);
            }
        }
    }

    private void saveQueryItems(List<QueryItem> itemsToSave) {
        QueryHierarchyBatchUpdatePackage update = new QueryHierarchyBatchUpdatePackage(this.getProject().getWITContext());
        for (QueryItem item : itemsToSave) {
            if (item.isDeleted()) {
                update.deleteQueryItem(item);
                continue;
            }
            if (item.isNew()) {
                update.insertQueryItem(item);
                continue;
            }
            update.updateQueryItem(item);
        }
        update.update();
    }

    private void saveCompleted(List<QueryItem> itemsToSave) {
        for (QueryItem item : itemsToSave) {
            if (!(item instanceof QueryItemImpl)) continue;
            ((QueryItemImpl)item).onSaveCompleted();
        }
    }

    private void saveToOldServer() {
        ArrayList<QueryItem> itemsToSave = new ArrayList<QueryItem>();
        this.getDirtyItems(this, itemsToSave);
        try {
            for (QueryItem item : itemsToSave) {
                if (!(item instanceof QueryDefinition)) continue;
                this.saveQueryToOldServer((QueryDefinition)item);
                if (!(item instanceof QueryDefinitionImpl)) continue;
                ((QueryDefinitionImpl)item).onSaveCompleted();
            }
        }
        catch (ValidationException e) {
            if (e.getType() == ValidationException.Type.NOT_UNIQUE_STORED_QUERY) {
                throw new QueryHierarchyException(Messages.getString("QueryHierarchy.AnotherStoredQueryExistsWithTheSameName"), e, QueryHierarchyException.Type.NAME_CONFLICTS_WITH_EXISTING_ITEM);
            }
            throw e;
        }
        catch (UnauthorizedAccessException e) {
            throw new QueryHierarchyException(Messages.getString("QueryHierarchy.StoredQueryDoesNotExistOrNoPermission"), e, QueryHierarchyException.Type.DENIED_OR_NOT_EXIST);
        }
    }

    private void saveQueryToOldServer(QueryDefinition query) {
        Project project = this.getProject();
        StoredQueryProviderImpl queryProvider = project.getWITContext().getQueryProvider();
        StoredQueryBucket queryBucket = queryProvider.getQueryBucket(project.getID());
        if (query.isNew()) {
            if (!query.isDeleted()) {
                this.addStoredQuery(query, queryProvider);
            }
        } else {
            StoredQueryBucket originalQueryBucket = queryBucket;
            if (query.getParent() != query.getOriginalParent() && query.getOriginalParent() != null) {
                originalQueryBucket = queryProvider.getQueryBucket(query.getOriginalParent().getProject().getID());
            }
            StoredQuery storedQuery = null;
            for (StoredQuery testQuery : originalQueryBucket.getQueryList()) {
                if (!testQuery.getQueryGUID().equals(query.getID())) continue;
                storedQuery = testQuery;
            }
            if (query.isDeleted()) {
                queryProvider.deleteStoredQuery((StoredQueryImpl)storedQuery);
            } else {
                if (query.getParent() != query.getOriginalParent()) {
                    this.addStoredQuery(query, queryProvider);
                    try {
                        queryProvider.deleteStoredQuery((StoredQueryImpl)storedQuery);
                        return;
                    }
                    catch (RuntimeException e) {
                        QueryFolder originalParent = query.getOriginalParent();
                        if (query instanceof QueryDefinitionImpl) {
                            ((QueryDefinitionImpl)query).resetDirty();
                        }
                        if (query.getParent() instanceof QueryFolderImpl) {
                            ((QueryFolderImpl)query.getParent()).onAddSaved(query);
                        }
                        if (originalParent instanceof QueryFolderImpl) {
                            ((QueryFolderImpl)originalParent).updateCollectionsForRemove(query);
                        }
                        new QueryDefinitionImpl(storedQuery.getName(), storedQuery.getQueryText(), originalParent, storedQuery.getQueryGUID(), IdentityHelper.createDescriptorFromSID(storedQuery.getOwner()));
                        throw e;
                    }
                }
                storedQuery.setName(query.getName());
                storedQuery.setQueryText(query.getQueryText());
                storedQuery.update();
            }
        }
    }

    private void addStoredQuery(QueryDefinition query, StoredQueryProviderImpl storedQueryProvider) {
        QueryScope queryScope = query.getParent().getName().equals(PRIVATE_QUERY_FOLDER_NAME) ? QueryScope.PRIVATE : QueryScope.PUBLIC;
        Project project = this.getProject();
        StoredQueryImpl storedQuery = new StoredQueryImpl(queryScope, query.getName(), query.getQueryText(), null);
        storedQuery.setProjectID(project.getID());
        storedQuery.setWITContext(project.getWITContext());
        storedQuery.setQueryProvider(storedQueryProvider);
        storedQuery.setProject((ProjectImpl)project);
        storedQueryProvider.addStoredQuery(storedQuery);
        if (query instanceof QueryDefinitionImpl) {
            ((QueryDefinitionImpl)query).setID(storedQuery.getQueryGUID());
        }
    }

    private void fireHierarchyRefreshedEvent() {
    }

    private void fireHierarchyResetEvent() {
    }
}

