/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeAndOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeBoolConst;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeMode;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Priority;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class NodeSelect
extends NodeList {
    public NodeSelect() {
        super(NodeType.SELECT, 7);
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        Tools.ensureSyntax(this.getFrom() != null, SyntaxError.FROM_IS_NOT_SPECIFIED, null);
        this.getFrom().bind(e, null, null);
        Tools.ensureSyntax(this.getFrom().getNodeType() == NodeType.TABLE_NAME, SyntaxError.EXPECTING_TABLE_NAME, this.getFrom());
        if (this.getMode() != null) {
            this.getMode().bind(e, this.getFrom(), null);
        }
        if (this.getFields() != null) {
            this.getFields().bind(e, this.getFrom(), null);
            Tools.ensureSyntax(this.getFields().getNodeType() == NodeType.FIELD_LIST, SyntaxError.EXPECTING_FIELD_LIST, this.getFields());
        }
        if (this.getGroupBy() != null) {
            this.getGroupBy().bind(e, this.getFrom(), null);
            Tools.ensureSyntax(this.getGroupBy().getNodeType() == NodeType.GROUP_FIELD_LIST, SyntaxError.EXPECTING_FIELD_LIST, this.getGroupBy());
        }
        if (this.getOrderBy() != null) {
            this.getOrderBy().bind(e, this.getFrom(), null);
            Tools.ensureSyntax(this.getOrderBy().getNodeType() == NodeType.ORDER_FIELD_LIST, SyntaxError.EXPECTING_FIELD_LIST, this.getOrderBy());
        }
        if (this.getWhere() != null) {
            this.getWhere().bind(e, this.getFrom(), null);
            Tools.ensureSyntax(this.getWhere().getDataType() == DataType.BOOL, SyntaxError.EXPECTING_CONDITION, this.getWhere());
        }
        if (this.getAsOf() != null) {
            this.getAsOf().bind(e, this.getFrom(), null);
            if (e != null) {
                Tools.ensureSyntax(this.getAsOf().isScalar() && this.getAsOf().canCastTo(DataType.DATE, e.getLocale()), SyntaxError.EXPECTING_DATE, this.getAsOf());
            }
        }
        super.bind(e, tableContext, fieldContext);
    }

    public Map<String, NodeAndOperator> getWhereGroups() {
        String prefix;
        int i;
        HashMap<String, NodeAndOperator> whereGroups = new HashMap<String, NodeAndOperator>();
        Node node = this.getWhere();
        if (node instanceof NodeAndOperator) {
            NodeAndOperator and = (NodeAndOperator)node;
            for (i = 0; i < and.getCount(); ++i) {
                node = and.getItem(i);
                String prefix2 = node.checkPrefix(null);
                if (prefix2 == null) continue;
                NodeAndOperator list = (NodeAndOperator)whereGroups.get(prefix2);
                if (list != null) {
                    list.add(node);
                    continue;
                }
                list = new NodeAndOperator();
                list.add(node);
                whereGroups.put(prefix2, list);
            }
        } else if (node != null && (prefix = node.checkPrefix(null)) != null) {
            NodeAndOperator list = new NodeAndOperator();
            list.add(node);
            whereGroups.put(prefix, list);
        }
        String[] keys = whereGroups.keySet().toArray(new String[whereGroups.keySet().size()]);
        for (i = 0; i < keys.length; ++i) {
            NodeAndOperator a = (NodeAndOperator)whereGroups.get(keys[i]);
            if (a.getCount() != 1 || !(a.getItem(0) instanceof NodeAndOperator)) continue;
            whereGroups.put(keys[i], (NodeAndOperator)a.getItem(0));
        }
        return whereGroups;
    }

    @Override
    public Node optimize(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (this.getWhere() != null) {
            this.setWhere(this.getWhere().optimize(e, this.getFrom(), null));
        }
        if (this.getAsOf() != null) {
            this.setAsOf(this.getAsOf().optimize(e, null, null));
        }
        return super.optimize(e, tableContext, fieldContext);
    }

    @Override
    public void appendTo(StringBuffer b) {
        String[] strArray = new String[]{"{0}", " from {0}", " where {0}", "group by {0}", " order by {0}", " asof {0}", " mode ({0})"};
        b.append("select ");
        for (int i = 0; i < strArray.length; ++i) {
            String str;
            Node objA = this.getItem(i);
            if (objA == this.getWhere() && objA instanceof NodeBoolConst && ((NodeBoolConst)objA).getValue()) {
                objA = null;
            }
            if (objA == null || (str = objA.toString()) == null || str.equals("")) continue;
            b.append(new MessageFormat(strArray[i]).format(new Object[]{str}));
        }
    }

    public Node getAsOf() {
        return this.getItem(5);
    }

    public void setAsOf(Node node) {
        this.setItem(5, node);
    }

    @Override
    public DataType getDataType() {
        return DataType.VOID;
    }

    public NodeFieldList getFields() {
        return (NodeFieldList)this.getItem(0);
    }

    public void setFields(NodeFieldList fields) {
        this.setItem(0, fields);
    }

    public NodeTableName getFrom() {
        return (NodeTableName)this.getItem(1);
    }

    public void setFrom(NodeTableName from) {
        this.setItem(1, from);
    }

    public NodeFieldList getGroupBy() {
        return (NodeFieldList)this.getItem(3);
    }

    public void setGroupBy(NodeFieldList groupBy) {
        this.setItem(3, groupBy);
    }

    public NodeFieldList getOrderBy() {
        return (NodeFieldList)this.getItem(4);
    }

    public void setOrderBy(NodeFieldList orderBy) {
        this.setItem(4, orderBy);
    }

    @Override
    public Priority getPriority() {
        return Priority.SELECT_OPERATOR;
    }

    public Node getWhere() {
        return this.getItem(2);
    }

    public void setWhere(Node where) {
        this.setItem(2, where);
    }

    public NodeMode getMode() {
        return (NodeMode)this.getItem(6);
    }

    public void setMode(NodeMode mode) {
        this.setItem(6, mode);
    }
}

