/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.chunkingcodec;

import com.microsoft.tfs.util.chunkingcodec.ChunkedDecoder;
import java.io.IOException;

public abstract class ChunkedDecoderArray
implements ChunkedDecoder {
    private ChunkedDecoder currentDecoder;
    private int decoderIdx = 0;
    private boolean complete = false;

    protected ChunkedDecoderArray() {
    }

    private void getNextDecoder() {
        this.currentDecoder = this.start(this.decoderIdx);
        ++this.decoderIdx;
        if (this.currentDecoder == null) {
            this.complete = true;
        }
    }

    protected abstract ChunkedDecoder start(int var1);

    @Override
    public final int decode(byte[] buf, int off, int len) throws IOException {
        int doneLen = 0;
        if (this.currentDecoder == null) {
            this.getNextDecoder();
        }
        while (doneLen < len && !this.complete) {
            doneLen += this.currentDecoder.decode(buf, off + doneLen, len - doneLen);
            if (!this.currentDecoder.isComplete()) continue;
            this.getNextDecoder();
        }
        return doneLen;
    }

    protected void completed(int idx, ChunkedDecoder decoder) {
    }

    @Override
    public final boolean isComplete() {
        return this.complete;
    }

    public void close() throws IOException {
    }
}

