/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.valid;

import com.microsoft.tfs.util.valid.IValidity;
import com.microsoft.tfs.util.valid.Validatable;
import com.microsoft.tfs.util.valid.Validator;
import com.microsoft.tfs.util.valid.ValidatorBinding;
import com.microsoft.tfs.util.valid.ValidityChangedEvent;

public abstract class AbstractValidatorBinding
implements ValidatorBinding {
    private final ValidityChangedListener validityChangedListener = new ValidityChangedListener();
    private Validator validator;
    private final Object validatorLock = new Object();

    protected abstract void update(IValidity var1);

    @Override
    public void bind(Validatable validatable) {
        if (validatable == null) {
            this.bind((Validator)null);
        } else {
            this.bind(validatable.getValidator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Validator newValidator) {
        IValidity validity = null;
        Object object = this.validatorLock;
        synchronized (object) {
            if (this.validator != null) {
                this.validator.removeValidityChangedListener(this.validityChangedListener);
            }
            this.validator = newValidator;
            if (this.validator != null) {
                this.validator.addValidityChangedListener(this.validityChangedListener);
                validity = this.validator.getValidity();
            }
        }
        this.update(validity);
    }

    @Override
    public Validator getBoundValidator() {
        return this.validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind() {
        Object object = this.validatorLock;
        synchronized (object) {
            if (this.validator != null) {
                this.validator.removeValidityChangedListener(this.validityChangedListener);
                this.validator = null;
            }
        }
        this.update(null);
    }

    private class ValidityChangedListener
    implements com.microsoft.tfs.util.valid.ValidityChangedListener {
        private ValidityChangedListener() {
        }

        @Override
        public void validityChanged(ValidityChangedEvent event) {
            AbstractValidatorBinding.this.update(event.getValidity());
        }
    }
}

