/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metadata.abap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.metadata.IFileMetadata;
import com.teamscale.index.metadata.abap.EAbapLanguageVersion;
import com.teamscale.index.metadata.abap.EAbapProgramType;
import com.teamscale.index.metadata.abap.ReleaseContract;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class AbapFileMetadata
implements IFileMetadata {
    private static final long serialVersionUID = 1L;
    private static final String FILE_PATH_PROPERTY = "filePath";
    public static final String ORIGINATING_SYSTEM_PROPERTY = "originatingSystem";
    public static final String CREATION_DATE_PROPERTY = "creationDate";
    public static final String LAST_UPDATE_DATE_TIME_PROPERTY = "lastUpdateDateTime";
    public static final String PROGRAM_TYPE_PROPERTY = "programType";
    public static final String AUTHORIZATION_GROUP_PROPERTY = "authorizationGroup";
    public static final String IS_RFC_ENABLED_PROPERTY = "isRfcEnabled";
    public static final String IS_GENERATED_CODE_PROPERTY = "isGeneratedCode";
    public static final String LANGUAGE_VERSION_PROPERTY = "languageVersion";
    public static final String RELEASE_CONTRACT_PROPERTY = "releaseContract";
    @JsonProperty(value="filePath")
    private final String filePath;
    @JsonProperty(value="originatingSystem")
    private @Nullable String originatingSystem;
    @JsonProperty(value="creationDate")
    private long creationDate;
    @JsonProperty(value="lastUpdateDateTime")
    private long lastUpdateDateTime;
    @JsonProperty(value="programType")
    private @Nullable EAbapProgramType programType;
    @JsonProperty(value="authorizationGroup")
    private @Nullable String authorizationGroup;
    @JsonProperty(value="isRfcEnabled")
    private boolean rfcIsEnabled;
    @JsonProperty(value="isGeneratedCode")
    private boolean codeIsGenerated;
    @JsonProperty(value="languageVersion")
    private @Nullable EAbapLanguageVersion languageVersion;
    @JsonProperty(value="releaseContract")
    private @Nullable ReleaseContract releaseContract;

    @JsonCreator
    public AbapFileMetadata(@JsonProperty(value="filePath") String filePath, @JsonProperty(value="creationDate") long creationDate, @JsonProperty(value="lastUpdateDateTime") long lastUpdateDateTime, @JsonProperty(value="originatingSystem") @Nullable String originatingSystem, @JsonProperty(value="programType") @Nullable EAbapProgramType programType, @JsonProperty(value="authorizationGroup") @Nullable String authorizationGroup, @JsonProperty(value="languageVersion") @Nullable EAbapLanguageVersion languageVersion, @JsonProperty(value="releaseContract") @Nullable ReleaseContract releaseContract, @JsonProperty(value="isRfcEnabled") boolean rfcIsEnabled, @JsonProperty(value="isGeneratedCode") boolean codeIsGenerated) {
        this.filePath = filePath;
        this.creationDate = creationDate;
        this.lastUpdateDateTime = lastUpdateDateTime;
        this.originatingSystem = originatingSystem;
        this.programType = programType;
        this.authorizationGroup = authorizationGroup;
        this.languageVersion = languageVersion;
        this.releaseContract = releaseContract;
        this.rfcIsEnabled = rfcIsEnabled;
        this.codeIsGenerated = codeIsGenerated;
    }

    @Override
    public PairList<String, Serializable> getMetrics() {
        PairList metrics = new PairList();
        metrics.add((Object)CREATION_DATE_PROPERTY, (Object)this.creationDate);
        metrics.add((Object)LAST_UPDATE_DATE_TIME_PROPERTY, (Object)this.lastUpdateDateTime);
        metrics.add((Object)ORIGINATING_SYSTEM_PROPERTY, this.toMetric(this.originatingSystem));
        metrics.add((Object)PROGRAM_TYPE_PROPERTY, EAbapProgramType.toMetric(this.programType));
        metrics.add((Object)LANGUAGE_VERSION_PROPERTY, EAbapLanguageVersion.toMetric(this.languageVersion));
        metrics.add((Object)AUTHORIZATION_GROUP_PROPERTY, this.toMetric(this.authorizationGroup));
        return metrics;
    }

    private CounterSet<String> toMetric(@Nullable String value) {
        if (value == null) {
            return CounterSet.empty();
        }
        return new CounterSet((Object)value, 1);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getOriginatingSystem() {
        return this.originatingSystem;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getLastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public void setOriginatingSystem(String originatingSystem) {
        this.originatingSystem = originatingSystem;
    }

    public void setLastUpdateDateTime(long lastUpdateDateTime) {
        this.lastUpdateDateTime = lastUpdateDateTime;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public boolean isRfcEnabled() {
        return this.rfcIsEnabled;
    }

    public void setRfcEnabled(boolean rfcIsEnabled) {
        this.rfcIsEnabled = rfcIsEnabled;
    }

    public void setProgramType(EAbapProgramType programType) {
        this.programType = programType;
    }

    public void setLanguageVersion(EAbapLanguageVersion languageVersion) {
        this.languageVersion = languageVersion;
    }

    public void setAuthorizationGroup(String authorizationGroup) {
        this.authorizationGroup = authorizationGroup;
    }

    public void setReleaseContract(ReleaseContract releaseContract) {
        this.releaseContract = releaseContract;
    }

    public void setCodeIsGenerated(boolean codeIsGenerated) {
        this.codeIsGenerated = codeIsGenerated;
    }

    public EAbapProgramType getProgramType() {
        return this.programType;
    }

    public EAbapLanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    public String getAuthorizationGroup() {
        return this.authorizationGroup;
    }

    public ReleaseContract getReleaseContract() {
        return this.releaseContract;
    }

    public boolean isCodeGenerated() {
        return this.codeIsGenerated;
    }
}

