/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestBase;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class PrioritizableTest
extends PrioritizableTestBase {
    private static final long serialVersionUID = 0L;
    @JsonProperty(value="uniformPath")
    private UniformPath uniformPath;
    @JsonProperty(value="testName")
    private String testName;
    @JsonProperty(value="selectionReason")
    private ETestSelectionReason selectionReason;
    @JsonProperty(value="partition")
    private String partition;
    @JsonProperty(value="coveredMethodCount")
    private int numberOfCoveredMethods = 0;

    @JsonCreator
    public PrioritizableTest() {
    }

    public PrioritizableTest(UniformPath uniformPath, ETestSelectionReason selectionReason, String partition) {
        this(uniformPath, selectionReason, partition, Collections.emptySet());
    }

    public PrioritizableTest(UniformPath uniformPath, ETestSelectionReason selectionReason, String partition, Set<MethodId> changedMethodLocations) {
        super(changedMethodLocations);
        this.uniformPath = uniformPath;
        this.testName = TestUniformPathUtils.convertCoverageUnitPathToTestName(uniformPath.toString());
        this.selectionReason = selectionReason;
        this.partition = partition;
        this.setCoveredMethods(changedMethodLocations);
    }

    @JsonGetter(value="type")
    public UniformPath.EType getUniformPathType() {
        return this.uniformPath.getType();
    }

    public static PrioritizableTest createForAddedOrModifiedTest(String partition, UniformPath uniformPath) {
        return new PrioritizableTest(uniformPath, ETestSelectionReason.ADDED_OR_MODIFIED_TEST, partition);
    }

    public void setDurationInMs(Long durationInMs) {
        this.durationInMs = durationInMs;
    }

    public boolean isDurationSet() {
        return this.durationInMs != null;
    }

    public void setCoveredMethods(Set<MethodId> coveredMethods) {
        this.coveredMethods = coveredMethods;
        this.numberOfCoveredMethods = coveredMethods.size();
    }

    public String getPartition() {
        return this.partition;
    }

    @Override
    public Set<ETestSelectionReason> getSelectionReasons() {
        return Collections.singleton(this.selectionReason);
    }

    @Override
    public Optional<Long> getDurationInMs() {
        return Optional.ofNullable(this.durationInMs);
    }

    @Override
    public Set<MethodId> getCoveredMethods() {
        if (this.coveredMethods == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.coveredMethods);
    }

    @Override
    public long getNumberOfCoveredMethods() {
        return this.numberOfCoveredMethods;
    }

    public UniformPath getUniformPath() {
        return this.uniformPath;
    }

    public String getUniformPathString() {
        return this.uniformPath.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrioritizableTest that = (PrioritizableTest)o;
        return Objects.equals(this.uniformPath, that.uniformPath) && Objects.equals(this.partition, that.partition);
    }

    public int hashCode() {
        return Objects.hash(this.uniformPath, this.partition);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper(this).toString();
    }

    @Override
    public String getIdentifier() {
        return String.valueOf(this.uniformPath) + ";" + this.partition;
    }
}

