/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.awt.Color;
import java.io.IOException;
import org.conqat.lib.commons.color.ColorUtils;

public class ColorSerializationModule
extends SimpleModule {
    ColorSerializationModule() {
        this.addSerializer(Color.class, new ColorSerializer());
        this.addDeserializer(Color.class, new ColorDeserializer());
    }

    private static class ColorSerializer
    extends JsonSerializer<Color> {
        private ColorSerializer() {
        }

        public void serialize(Color value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(ColorUtils.toHtmlString((Color)value));
        }
    }

    private static class ColorDeserializer
    extends JsonDeserializer<Color> {
        private ColorDeserializer() {
        }

        public Color deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String root = p.getText();
            return ColorUtils.fromString((String)root);
        }
    }
}

