/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;

public class FindingDelta
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ADDED_FINDINGS_PROPERTY = "addedFindings";
    private static final String FINDINGS_IN_CHANGED_CODE_PROPERTY = "findingsInChangedCode";
    private static final String REMOVED_FINDINGS_PROPERTY = "removedFindings";
    @JsonProperty(value="addedFindings")
    private final List<TrackedFinding> addedFindings;
    @JsonProperty(value="findingsInChangedCode")
    private final List<TrackedFinding> findingsInChangedCode;
    @JsonProperty(value="removedFindings")
    private final List<TrackedFinding> removedFindings;

    public static FindingDelta create(Collection<TrackedFinding> addedFindings, Collection<TrackedFinding> findingsInChangedCode, Collection<TrackedFinding> removedFindings) {
        return new FindingDelta(addedFindings, findingsInChangedCode, removedFindings);
    }

    @JsonCreator
    public FindingDelta(@JsonProperty(value="addedFindings") Collection<TrackedFinding> addedFindings, @JsonProperty(value="findingsInChangedCode") Collection<TrackedFinding> findingsInChangedCode, @JsonProperty(value="removedFindings") Collection<TrackedFinding> removedFindings) {
        this.addedFindings = new ArrayList<TrackedFinding>(addedFindings);
        this.findingsInChangedCode = new ArrayList<TrackedFinding>(findingsInChangedCode);
        this.removedFindings = new ArrayList<TrackedFinding>(removedFindings);
    }

    public List<TrackedFinding> getAddedFindings() {
        return this.addedFindings;
    }

    public List<TrackedFinding> getFindingsInChangedCode() {
        return this.findingsInChangedCode;
    }

    public List<TrackedFinding> getRemovedFindings() {
        return this.removedFindings;
    }

    public int getNumberOfAddedFindings() {
        return this.addedFindings.size();
    }

    public int getNumberOfFindingsInChangedCode() {
        return this.findingsInChangedCode.size();
    }

    public int getNumberOfRemovedFindings() {
        return this.removedFindings.size();
    }

    public Set<TrackedFinding> getAllFindings() {
        return CollectionUtils.unionSet(this.addedFindings, (Collection[])new Collection[]{this.findingsInChangedCode, this.removedFindings});
    }
}

