/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public final class RelativeUniformPath {
    private final UnmodifiableList<String> segments;

    private RelativeUniformPath(String ... pathSegments) {
        this(Arrays.asList(pathSegments));
    }

    private RelativeUniformPath(List<String> pathSegments) {
        this.segments = CollectionUtils.asUnmodifiable(pathSegments.stream().map(UniformPath.INTERN).toList());
    }

    public static RelativeUniformPath of(String ... segments) {
        Preconditions.checkNotNull((Object)segments, (Object)"Segments list may not be null");
        return RelativeUniformPath.of(Arrays.asList(segments));
    }

    public static RelativeUniformPath of(List<String> segments) {
        Preconditions.checkNotNull(segments, (Object)"Segments list may not be null");
        for (String segment : segments) {
            UniformPath.checkSegmentValidity(segment, segments, Objects::isNull, "empty segment");
            UniformPath.checkSegmentValidity(segment, segments, UniformPath::containsUnescapedSlash, "contains unescaped slash");
        }
        if (segments.isEmpty()) {
            return new RelativeUniformPath(new String[0]);
        }
        return new RelativeUniformPath(segments);
    }

    static List<String> resolveRelativeSegments(List<String> pathSegments) {
        List canonicalSegments = CollectionUtils.filter(pathSegments, segment -> !StringUtils.isEmpty((String)segment) && !segment.equals("."));
        ListIterator canonicalSegmentsIterator = canonicalSegments.listIterator();
        while (canonicalSegmentsIterator.hasNext()) {
            if (!((String)canonicalSegmentsIterator.next()).equals("..")) continue;
            canonicalSegmentsIterator.previous();
            canonicalSegmentsIterator.remove();
            if (!canonicalSegmentsIterator.hasPrevious()) {
                throw new IllegalArgumentException("Invalid path (refers outside the root folder): " + String.join((CharSequence)"/", pathSegments));
            }
            canonicalSegmentsIterator.previous();
            canonicalSegmentsIterator.remove();
        }
        return canonicalSegments;
    }

    public UnmodifiableList<String> getSegments() {
        return this.segments;
    }

    public String getLastSegment() {
        if (this.segments.isEmpty()) {
            throw new IllegalArgumentException("Cannot get the last segment of the root path");
        }
        return (String)this.segments.getLast();
    }

    public RelativeUniformPath addSuffix(String ... suffix) {
        if (suffix.length == 0) {
            return this;
        }
        return RelativeUniformPath.of(Stream.concat(this.segments.stream(), Arrays.stream(suffix)).toList());
    }

    public UniformPath resolveAgainstAbsolutePath(UniformPath uniformPath) {
        return uniformPath.resolve(this);
    }

    public String toString() {
        return String.join((CharSequence)"/", this.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelativeUniformPath)) {
            return false;
        }
        RelativeUniformPath other = (RelativeUniformPath)obj;
        return this.segments.equals(other.segments);
    }
}

