/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui;

import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.backup.write.BackupExportOptions;
import com.teamscale.index.backup.write.BackupExportStatus;
import com.teamscale.index.backup.write.BackupWriter;
import com.teamscale.index.backup.write.BackupWritingParameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.statistics.StatisticsCollectingCallback;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class TeamscaleStartUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void dumpBackupIfRequested(@Nullable File backupFileToWriteOnStart, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (backupFileToWriteOnStart != null) {
            if (backupFileToWriteOnStart.exists()) {
                throw new StorageException("Backup file specified via startup parameter already exists: " + String.valueOf(backupFileToWriteOnStart));
            }
            TeamscaleStartUtils.dumpBackupFile(backupFileToWriteOnStart, indexLayer, lockProvider, instanceConfiguration);
        }
    }

    public static void dumpBackupFile(File backupFile, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration) throws StorageException {
        try {
            BackupExportOptions exportOptions = new BackupExportOptions().setExportGlobalData(true).setIncludeAllProjects(true);
            new BackupWriter(new BackupWritingParameters(exportOptions, indexLayer, lockProvider, FileSystemUtils.getTmpDir(), instanceConfiguration), ICancelable.neverCanceled()).writeBackupZip((OutputStream)new FileOutputStream(backupFile), new BackupExportStatus(exportOptions));
            LOGGER.fatal("A backup of the user generated data has been written to " + backupFile.getAbsolutePath() + ". You can delete the stored data and reinitialize Teamscale from this backup.");
        }
        catch (IOException | ExecutionCanceledException e) {
            LOGGER.fatal("Failed to write the backup file to " + backupFile.getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    public static void dumpStoreSizesIfRequested(@Nullable File storeSizeFileToWriteOnStart, IndexLayer indexLayer) throws StorageException, IOException {
        if (storeSizeFileToWriteOnStart == null) {
            return;
        }
        try (PrintWriter writer = new PrintWriter(storeSizeFileToWriteOnStart, StandardCharsets.UTF_8);){
            writer.println("Project;Store;" + StatisticsCollectingCallback.CSV_HEADER);
            TeamscaleStartUtils.dumpStoreSizeData((SchemaAwareStorageSystem)indexLayer.openGlobalStorageSystem(), "__global__", writer);
            for (ProjectInfo project : ((ProjectIndex)indexLayer.openGlobalIndex(ProjectIndex.class)).getAllProjectInfos()) {
                TeamscaleStartUtils.dumpStoreSizeData((SchemaAwareStorageSystem)indexLayer.openProjectStorageSystem(project), project.getPrimaryPublicId().toString(), writer);
            }
        }
    }

    private static void dumpStoreSizeData(SchemaAwareStorageSystem storageSystem, String projectName, PrintWriter writer) throws StorageException {
        for (String entry : storageSystem.getSchema().getEntryNames()) {
            IStore store = storageSystem.openStore(entry);
            StatisticsCollectingCallback callback = new StatisticsCollectingCallback();
            store.scan(new byte[0], (IKeyValueCallback)callback);
            writer.println(projectName + ";" + entry + ";" + callback.toCsvString());
        }
    }

    public static class AdminSettingsPartialValidator {
        private final Object lock = new Object();
        private IndexLayer indexLayer = null;
        private final IStorageInfo storageInfo = this.createPartialStorageInfo();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIndexLayer(IndexLayer indexLayer) {
            Object object = this.lock;
            synchronized (object) {
                this.indexLayer = indexLayer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate() {
            Object object = this.lock;
            synchronized (object) {
                if (this.indexLayer != null) {
                    ServerOptionRegistry.getInstance().attemptFileConfigOptionsValidationAndLog(this.storageInfo, null);
                }
            }
        }

        private IStorageInfo createPartialStorageInfo() {
            return new IStorageInfo(){

                public InternalProjectId getInternalId() {
                    return null;
                }

                public PublicProjectId getPrimaryPublicId() {
                    return null;
                }

                public ProjectStorageSystem getProjectStorageSystem() {
                    return null;
                }

                public GlobalStorageSystem getGlobalStorageSystem() {
                    if (indexLayer == null) {
                        return null;
                    }
                    try {
                        return indexLayer.openGlobalStorageSystem();
                    }
                    catch (StorageException e) {
                        LOGGER.warn("Could not open global storage system during admin settings file validation", (Throwable)e);
                        return null;
                    }
                }
            };
        }
    }
}

