/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.resources;

import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.ui.resources.WebUiAssetService;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.string.StringUtils;

@Hidden
@Path(value="{path: (?!(images/|js-libs/|node_modules/|public/|src/|favicon|safari_pinned_tab_icon|apple-touch-icon|robots|assets/)).*}")
public class TeamscalePerspectiveService
extends ApiBase {
    public static final String ALL_RESOURCE_PATHS = "(images/|js-libs/|node_modules/|public/|src/|favicon|safari_pinned_tab_icon|apple-touch-icon|robots|assets/)";
    private static final String BASE_TAG_START = "<base href=\"";
    private static final String INDEX_ENTRYPOINT = "<script type=\"module\" src=\"/src/Index.tsx\"></script>";
    private static final String MODIFIED_INDEX_ENTRYPOINT = "<script type=\"module\" src=\"http://localhost:9090/src/Index.tsx\"></script>";
    private static final String REACT_REFRESH_SCRIPT = "<script type=\"module\">\n  import { injectIntoGlobalHook } from \"http://localhost:9090/@react-refresh\";\n  injectIntoGlobalHook(window);\n  window.$RefreshReg$ = () => {};\n  window.$RefreshSig$ = () => (type) => type;\n        </script>\n";

    @GET
    @RequiresNoPermission
    @Produces(value={"text/html"})
    public String getPerspectiveHtml() {
        return TeamscalePerspectiveService.getIndexHtml(this.serviceInfo);
    }

    protected static String getIndexHtml(ITeamscaleServiceInfo serviceInfo) {
        String indexHtml = StringUtils.bytesToString((byte[])WebUiAssetService.getResource("index.html"));
        if (EFeatureToggle.isInUiDevServerMode()) {
            indexHtml = indexHtml.replace(INDEX_ENTRYPOINT, "<script type=\"module\">\n  import { injectIntoGlobalHook } from \"http://localhost:9090/@react-refresh\";\n  injectIntoGlobalHook(window);\n  window.$RefreshReg$ = () => {};\n  window.$RefreshSig$ = () => (type) => type;\n        </script>\n<script type=\"module\" src=\"http://localhost:9090/src/Index.tsx\"></script>");
        }
        indexHtml = indexHtml.replace("<base href=\"/", BASE_TAG_START + String.valueOf(serviceInfo.getRequestBaseUri()));
        return indexHtml;
    }
}

