/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeFalse;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeLeaf;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeTrue;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionTreeNode;

class ConditionInnerTreeNode
implements IConditionTreeNode {
    private ETokenType operator;
    private List<IConditionTreeNode> children;
    private final ConditionEvaluatorBase conditionEvaluator;

    ConditionInnerTreeNode(ETokenType operator, ConditionEvaluatorBase conditionEvaluator) {
        this.operator = operator;
        this.conditionEvaluator = conditionEvaluator;
        this.children = new ArrayList<IConditionTreeNode>();
    }

    ConditionInnerTreeNode(ETokenType operator, ConditionEvaluatorBase conditionEvaluator, List<ExpressionTreeNode> children) {
        this.operator = operator;
        this.children = children.stream().map(child -> new ConditionTreeNodeLeaf((ExpressionTreeNode)child, conditionEvaluator)).toList();
        this.conditionEvaluator = conditionEvaluator;
    }

    ConditionInnerTreeNode(ETokenType operator, List<IConditionTreeNode> children, ConditionEvaluatorBase conditionEvaluator) {
        this.operator = operator;
        this.children = new ArrayList<IConditionTreeNode>(children);
        this.conditionEvaluator = conditionEvaluator;
    }

    ConditionInnerTreeNode(ETokenType operator, IConditionTreeNode child, ConditionEvaluatorBase conditionEvaluator) {
        this.operator = operator;
        this.conditionEvaluator = conditionEvaluator;
        this.children = new ArrayList<IConditionTreeNode>();
        this.children.add(child);
    }

    @Override
    public IConditionTreeNode expand() {
        ArrayList<IConditionTreeNode> childrenExpanded = new ArrayList<IConditionTreeNode>();
        for (IConditionTreeNode node : this.children) {
            childrenExpanded.add(node.expand());
        }
        this.children = childrenExpanded;
        return this;
    }

    public IConditionTreeNode getSingleChild() {
        return this.children.toArray(new IConditionTreeNode[1])[0];
    }

    @Override
    public List<IConditionTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<IConditionTreeNode> children) {
        this.children = children;
    }

    @Override
    public IConditionTreeNode toCnf() {
        this.prepareChildren();
        if (this.operator == ConditionEvaluatorBase.getNegationOperator()) {
            if (this.children.size() != 1) {
                return this;
            }
            return this.getNegatedChild();
        }
        if (this.operator == this.conditionEvaluator.getAndOperator()) {
            Set<IConditionTreeNode> flattenedChildren = this.flattenedChildren(this.operator);
            if (ConditionEvaluatorBase.childrenContainFalse(flattenedChildren)) {
                return new ConditionTreeNodeFalse();
            }
            this.children = this.conditionEvaluator.simplifyAndChildrenSet(flattenedChildren);
        } else if (this.operator == this.conditionEvaluator.getOrOperator()) {
            Set<IConditionTreeNode> flattenedChildren = this.flattenedChildren(this.operator);
            if (ConditionEvaluatorBase.childrenContainTrue(flattenedChildren)) {
                return new ConditionTreeNodeTrue();
            }
            if (flattenedChildren.stream().noneMatch(child -> child instanceof ConditionInnerTreeNode && ((ConditionInnerTreeNode)child).operator == this.conditionEvaluator.getAndOperator())) {
                return this.conditionEvaluator.simplifyOrNode(this);
            }
            this.bringChildrenToCNF(flattenedChildren);
        }
        return this.evaluateApplicableEquality();
    }

    @Override
    public IConditionTreeNode simplify() {
        Set<IConditionTreeNode> flattenedChildren = this.flattenedChildren(this.operator);
        if (this.operator == this.conditionEvaluator.getAndOperator() && ConditionEvaluatorBase.childrenContainFalse(flattenedChildren)) {
            return new ConditionTreeNodeFalse();
        }
        if (this.operator == this.conditionEvaluator.getOrOperator() && ConditionEvaluatorBase.childrenContainTrue(flattenedChildren)) {
            return new ConditionTreeNodeTrue();
        }
        if (!this.conditionEvaluator.isNotEqualOperator(this.operator)) {
            return this.evaluateApplicableEquality();
        }
        return this;
    }

    private IConditionTreeNode evaluateApplicableEquality() {
        if (this.children.size() == 1) {
            return this.getSingleChild();
        }
        if (this.children.size() == 2 && this.children.get(0).equals(this.children.get(1)) && !this.children.get(0).isKeyword() && !this.children.get(1).isKeyword()) {
            if (this.conditionEvaluator.isEqualOperator(this.operator)) {
                return new ConditionTreeNodeTrue();
            }
            if (this.conditionEvaluator.isNotEqualOperator(this.operator)) {
                return new ConditionTreeNodeFalse();
            }
        }
        return this;
    }

    private void prepareChildren() {
        this.children = this.isBooleanOperator() ? this.children.stream().map(IConditionTreeNode::toCnf).map(IConditionTreeNode::castToBoolean).collect(Collectors.toList()) : this.children.stream().map(IConditionTreeNode::toCnf).collect(Collectors.toList());
    }

    private IConditionTreeNode getNegatedChild() {
        IConditionTreeNode child = this.getSingleChild();
        return child.negateNode();
    }

    private void bringChildrenToCNF(Set<IConditionTreeNode> flattenedChildren) {
        Set<IConditionTreeNode> newChildren = this.conditionEvaluator.childrenOfConvertOr(flattenedChildren);
        this.operator = this.conditionEvaluator.getAndOperator();
        this.children = this.conditionEvaluator.simplifyAndChildrenSet(newChildren);
    }

    private boolean isBooleanOperator() {
        return this.operator == ConditionEvaluatorBase.getNegationOperator() || this.operator == this.conditionEvaluator.getOrOperator() || this.operator == this.conditionEvaluator.getAndOperator();
    }

    private Set<IConditionTreeNode> flattenedChildren(ETokenType operator) {
        LinkedHashSet<IConditionTreeNode> flattenedChildren = new LinkedHashSet<IConditionTreeNode>();
        for (IConditionTreeNode child : this.children) {
            if (child instanceof ConditionInnerTreeNode && ((ConditionInnerTreeNode)child).operator == operator) {
                flattenedChildren.addAll(((ConditionInnerTreeNode)child).children);
                continue;
            }
            flattenedChildren.add(child);
        }
        return flattenedChildren;
    }

    @Override
    public IConditionTreeNode negateNode() {
        if (this.operator == ConditionEvaluatorBase.getNegationOperator()) {
            return this.getSingleChild();
        }
        if (this.operator == this.conditionEvaluator.getAndOperator()) {
            this.operator = this.conditionEvaluator.getOrOperator();
            this.negateChildren();
        } else if (this.operator == this.conditionEvaluator.getOrOperator()) {
            this.operator = this.conditionEvaluator.getAndOperator();
            this.negateChildren();
        } else if (this.conditionEvaluator.negationsForRelational.containsKey(this.operator)) {
            this.operator = this.conditionEvaluator.negationsForRelational.get(this.operator);
        } else {
            throw new IllegalStateException("Unexpected operator: " + String.valueOf(this.operator));
        }
        return this;
    }

    @Override
    public IConditionTreeNode castToBoolean() {
        return this;
    }

    private void negateChildren() {
        this.children = this.children.stream().map(IConditionTreeNode::negateNode).toList();
    }

    @Override
    public boolean contains(IConditionTreeNode node) {
        if (node instanceof ConditionTreeNodeLeaf) {
            return new HashSet<IConditionTreeNode>(this.children).contains(node);
        }
        if (node instanceof ConditionInnerTreeNode) {
            return !this.equals(node) && new HashSet<IConditionTreeNode>(this.children).containsAll(((ConditionInnerTreeNode)node).children);
        }
        return false;
    }

    @Override
    public boolean isOpposite(IConditionTreeNode node) {
        if (this.operator == ConditionEvaluatorBase.getNegationOperator()) {
            return this.getSingleChild().equals(node);
        }
        if (node instanceof ConditionInnerTreeNode) {
            ETokenType otherOperator = ((ConditionInnerTreeNode)node).operator;
            if (otherOperator == ConditionEvaluatorBase.getNegationOperator()) {
                return ((ConditionInnerTreeNode)node).getSingleChild().equals(this);
            }
            List<IConditionTreeNode> otherChildren = ((ConditionInnerTreeNode)node).children;
            if (this.children.size() == 2 && otherChildren.size() == 2) {
                return this.conditionEvaluator.negationsForRelational.get(this.operator) != null && this.conditionEvaluator.negationsForRelational.get(this.operator) == this.conditionEvaluator.relationalSuperSets.get(otherOperator) && this.children.equals(otherChildren) || this.conditionEvaluator.relationalSuperSets.get(this.operator) == this.conditionEvaluator.relationalSuperSets.get(otherOperator) && this.operator != otherOperator && this.children.get(1).equals(otherChildren.get(0)) && this.children.get(0).equals(otherChildren.get(1));
            }
        }
        return false;
    }

    @Override
    public boolean isKeyword() {
        return false;
    }

    @Override
    public ETokenType getOperator() {
        return this.operator;
    }

    public String toString() {
        if (this.operator == ConditionEvaluatorBase.getNegationOperator()) {
            return "NOT " + String.valueOf(this.getSingleChild());
        }
        StringBuilder sb = new StringBuilder();
        Iterator<IConditionTreeNode> iterator = this.children.iterator();
        sb.append("(");
        while (iterator.hasNext()) {
            IConditionTreeNode child = iterator.next();
            sb.append(child.toString().trim());
            if (!iterator.hasNext()) continue;
            sb.append(" ").append(this.operator.toString()).append(" ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConditionInnerTreeNode && this.operator == ((ConditionInnerTreeNode)other).operator) {
            List<IConditionTreeNode> otherChildren = ((ConditionInnerTreeNode)other).children;
            if (this.conditionEvaluator.getOperatorInformation().isCommutative(this.operator)) {
                return otherChildren.size() == this.children.size() && new HashSet<IConditionTreeNode>(this.children).containsAll(otherChildren) && new HashSet<IConditionTreeNode>(otherChildren).containsAll(this.children);
            }
            return otherChildren.equals(this.children);
        }
        if (other instanceof ConditionInnerTreeNode && this.conditionEvaluator.oppositeOperators.get(this.operator) == ((ConditionInnerTreeNode)other).operator) {
            List<IConditionTreeNode> otherChildren = ((ConditionInnerTreeNode)other).children;
            return this.children.size() == 2 && otherChildren.size() == 2 && this.children.get(0).equals(otherChildren.get(1)) && this.children.get(1).equals(otherChildren.get(0));
        }
        return false;
    }

    public int hashCode() {
        return 13 * this.operator.ordinal() + this.children.size();
    }
}

