/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5808")
public class AuthorizationsCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Vote methods should return at least once a negative response";
    private static final QualifiedName SYMFONY_VOTER_INTERFACE_NAMESPACE = QualifiedName.qualifiedName("Symfony\\Component\\Security\\Core\\Authorization\\Voter\\VoterInterface");
    private static final QualifiedName SYMFONY_VOTER_NAMESPACE = QualifiedName.qualifiedName("Symfony\\Component\\Security\\Core\\Authorization\\Voter\\Voter");
    private static final QualifiedName LARAVEL_GATE_NAMESPACE = QualifiedName.qualifiedName("Illuminate\\Support\\Facades\\Gate");
    private static final Set<String> VOTER_INTERFACE_COMPLIANT_RETURN_VALUES = new HashSet<String>(Arrays.asList("ACCESS_ABSTAIN", "ACCESS_DENIED"));
    private static final Set<String> LARAVEL_GATE_CLOSURE_COMPLIANT_RETURN_VALUES = new HashSet<String>(Arrays.asList("false", "null"));

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree methodDeclarationTree) {
        if (!CheckUtils.hasModifier(methodDeclarationTree, "abstract")) {
            String functionName = CheckUtils.trimQuotes(CheckUtils.getFunctionName(methodDeclarationTree));
            if ("vote".equalsIgnoreCase(functionName) && CheckUtils.isMethodInheritedFromClassOrInterface(SYMFONY_VOTER_INTERFACE_NAMESPACE, methodDeclarationTree)) {
                this.checkReturnStatements(methodDeclarationTree, VOTER_INTERFACE_COMPLIANT_RETURN_VALUES::contains);
            }
            if ("voteOnAttribute".equalsIgnoreCase(functionName) && CheckUtils.isMethodInheritedFromClassOrInterface(SYMFONY_VOTER_NAMESPACE, methodDeclarationTree)) {
                this.checkReturnStatements(methodDeclarationTree, "false"::equals);
            }
        }
        super.visitMethodDeclaration(methodDeclarationTree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(Tree.Kind.CLASS_MEMBER_ACCESS)) {
            MemberAccessTree memberAccessTree = (MemberAccessTree)callee;
            Optional<Object> argument = Optional.empty();
            if (this.isLaravelGateMethod(memberAccessTree, "define")) {
                argument = CheckUtils.argument(tree, "callback", 1);
            }
            if (this.isLaravelGateMethod(memberAccessTree, "before") || this.isLaravelGateMethod(memberAccessTree, "after")) {
                argument = CheckUtils.argument(tree, "callback", 0);
            }
            argument.map(CallArgumentTree::value).filter(FunctionExpressionTree.class::isInstance).map(FunctionExpressionTree.class::cast).ifPresent(a -> this.checkReturnStatements((FunctionTree)a, LARAVEL_GATE_CLOSURE_COMPLIANT_RETURN_VALUES::contains));
        }
        super.visitFunctionCall(tree);
    }

    private boolean isLaravelGateMethod(MemberAccessTree memberAccessTree, String expectedMethod) {
        ExpressionTree receiver = memberAccessTree.object();
        Tree method = memberAccessTree.member();
        return method.is(Tree.Kind.NAME_IDENTIFIER) && ((NameIdentifierTree)method).text().equals(expectedMethod) && receiver.is(Tree.Kind.NAMESPACE_NAME) && this.getFullyQualifiedName((NamespaceNameTree)receiver).equals(LARAVEL_GATE_NAMESPACE);
    }

    private void checkReturnStatements(FunctionTree methodDeclarationTree, Predicate<String> predicate) {
        List<ReturnStatementTree> returnStatements = TreeUtils.descendants(methodDeclarationTree, ReturnStatementTree.class).toList();
        for (ReturnStatementTree returnStatementTree : returnStatements) {
            if (!CompliantResultStatement.create(returnStatementTree.expression(), predicate).isCompliant()) continue;
            return;
        }
        if (returnStatements.isEmpty()) {
            this.context().newIssue(this, methodDeclarationTree, MESSAGE);
        } else {
            this.context().newIssue(this, returnStatements.get(returnStatements.size() - 1), MESSAGE);
        }
    }

    private record CompliantResultStatement(ExpressionTree returnExpressionTree, Predicate<String> predicate) {
        static CompliantResultStatement create(ExpressionTree returnExpressionTree, Predicate<String> predicate) {
            return new CompliantResultStatement(returnExpressionTree, predicate);
        }

        boolean isCompliant() {
            return switch (this.returnExpressionTree.getKind()) {
                case Tree.Kind.NUMERIC_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL -> false;
                case Tree.Kind.FUNCTION_CALL -> this.isFunctionCallCompliant();
                case Tree.Kind.VARIABLE_IDENTIFIER -> this.isVariableValueCompliant();
                case Tree.Kind.CLASS_MEMBER_ACCESS -> this.isMemberValueCompliant();
                case Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL -> this.isBooleanOrNullLiteralValueCompliant();
                default -> true;
            };
        }

        boolean isFunctionCallCompliant() {
            return !"response::allow".equalsIgnoreCase(CheckUtils.nameOf(((FunctionCallTree)this.returnExpressionTree).callee()));
        }

        boolean isVariableValueCompliant() {
            Optional<ExpressionTree> uniqueAssignedValue = CheckUtils.uniqueAssignedValue((VariableIdentifierTree)this.returnExpressionTree);
            return uniqueAssignedValue.map(expressionTree -> CompliantResultStatement.create(expressionTree, this.predicate).isCompliant()).orElse(true);
        }

        boolean isBooleanOrNullLiteralValueCompliant() {
            return this.predicate.test(((LiteralTree)this.returnExpressionTree).value().toLowerCase(Locale.ROOT));
        }

        boolean isMemberValueCompliant() {
            return this.predicate.test(CheckUtils.nameOf(((MemberAccessTree)this.returnExpressionTree).member()));
        }
    }
}

