/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.ast.BoundaryTree;
import org.sonarsource.analyzer.commons.regex.ast.DisjunctionTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;
import org.sonarsource.analyzer.commons.regex.ast.SequenceTree;

public class AnchorPrecedenceFinder
extends RegexBaseVisitor {
    public static final String MESSAGE = "Group parts of the regex together to make the intended operator precedence explicit.";
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;

    public AnchorPrecedenceFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
    }

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        List<RegexTree> alternatives = tree.getAlternatives();
        if ((AnchorPrecedenceFinder.anchoredAt(alternatives, Position.BEGINNING) || AnchorPrecedenceFinder.anchoredAt(alternatives, Position.END)) && AnchorPrecedenceFinder.notAnchoredElseWhere(alternatives)) {
            this.regexElementIssueReporter.report(tree, MESSAGE, null, Collections.emptyList());
        }
        super.visitDisjunction(tree);
    }

    private static boolean anchoredAt(List<RegexTree> alternatives, Position position) {
        int itemIndex = position == Position.BEGINNING ? 0 : alternatives.size() - 1;
        RegexTree firstOrLast = alternatives.get(itemIndex);
        return AnchorPrecedenceFinder.isAnchored(firstOrLast, position);
    }

    private static boolean notAnchoredElseWhere(List<RegexTree> alternatives) {
        if (AnchorPrecedenceFinder.isAnchored(alternatives.get(0), Position.END) || AnchorPrecedenceFinder.isAnchored(alternatives.get(alternatives.size() - 1), Position.BEGINNING)) {
            return false;
        }
        for (RegexTree alternative : alternatives.subList(1, alternatives.size() - 1)) {
            if (!AnchorPrecedenceFinder.isAnchored(alternative, Position.BEGINNING) && !AnchorPrecedenceFinder.isAnchored(alternative, Position.END)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAnchored(RegexTree tree, Position position) {
        if (!tree.is(RegexTree.Kind.SEQUENCE)) {
            return false;
        }
        SequenceTree sequence = (SequenceTree)tree;
        List items = sequence.getItems().stream().filter(item -> !AnchorPrecedenceFinder.isFlagSetter(item)).collect(Collectors.toList());
        if (items.isEmpty()) {
            return false;
        }
        int index = position == Position.BEGINNING ? 0 : items.size() - 1;
        RegexTree firstOrLast = (RegexTree)items.get(index);
        return firstOrLast.is(RegexTree.Kind.BOUNDARY) && AnchorPrecedenceFinder.isAnchor((BoundaryTree)firstOrLast);
    }

    private static boolean isAnchor(BoundaryTree tree) {
        switch (tree.type()) {
            case INPUT_START: 
            case LINE_START: 
            case INPUT_END: 
            case INPUT_END_FINAL_TERMINATOR: 
            case LINE_END: {
                return true;
            }
        }
        return false;
    }

    private static boolean isFlagSetter(RegexTree tree) {
        return tree.is(RegexTree.Kind.NON_CAPTURING_GROUP) && ((NonCapturingGroupTree)tree).getElement() == null;
    }

    private static enum Position {
        BEGINNING,
        END;

    }
}

