/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.authentication;

import com.teamscale.core.rest.IMultiPartFormDataProvider;
import com.teamscale.core.user.User;
import com.teamscale.core.utils.HttpRequestUtils;
import com.teamscale.service.framework.IServiceStatisticsRecorder;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.impl.authentication.BasicSecurityContext;
import com.teamscale.service.framework.impl.error.ExceptionMapperBase;
import com.teamscale.service.framework.impl.logging.ServiceLogHandlerUtils;
import com.teamscale.service.framework.impl.util.ForwardedHeaderUtils;
import com.teamscale.service.framework.impl.util.JaxRsFormDataProvider;
import jakarta.annotation.Priority;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;

@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    @Context
    private IStaticServiceContext staticServiceContext;
    @Context
    private Providers providers;
    @Context
    private ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext = this.createVerifiedSecurityContext(requestContext);
        if (securityContext == null) {
            requestContext.abortWith(this.handleUnauthenticatedUser(this.resourceInfo.getResourceMethod(), requestContext));
        }
        requestContext.setSecurityContext(securityContext);
    }

    private @Nullable SecurityContext createVerifiedSecurityContext(ContainerRequestContext requestContext) {
        User user = AuthenticationFilter.authenticateUser(requestContext, this.staticServiceContext, this.providers);
        if (user == null) {
            return null;
        }
        IProjectId projectId = ServiceLogHandlerUtils.determineProject(requestContext);
        IServiceStatisticsRecorder statisticsRecorder = this.staticServiceContext.getServiceStatisticsRecorder();
        statisticsRecorder.updateUserAccess(projectId, user.getUsername());
        statisticsRecorder.updateUserAgent(user.getUsername(), requestContext.getHeaderString("User-Agent"));
        return new BasicSecurityContext(user);
    }

    private Response handleUnauthenticatedUser(Method resourceMethod, ContainerRequestContext requestContext) {
        String target = StringUtils.stripPrefix((String)requestContext.getUriInfo().getRequestUri().toString(), (String)requestContext.getUriInfo().getBaseUri().toString());
        if (HttpRequestUtils.isHtmlRequest((ContainerRequestContext)requestContext)) {
            URI baseUri = ForwardedHeaderUtils.getBaseUri(requestContext);
            String redirectUrl = this.staticServiceContext.getSsoRedirectionHandler().getRedirectUrl(target, baseUri).orElseGet(() -> AuthenticationFilter.loginPageFallback(baseUri, target));
            return Response.seeOther((URI)AuthenticationFilter.parseToURI(redirectUrl)).build();
        }
        return ExceptionMapperBase.buildResponse(requestContext, resourceMethod, Response.Status.UNAUTHORIZED, new NotAuthorizedException((Object)"Not authorized!", new Object[0]));
    }

    private static String loginPageFallback(URI baseUri, String target) {
        return StringUtils.ensureEndsWith((String)baseUri.toString(), (String)"/") + "login?target=" + UrlUtils.encodeQueryParameter((String)target);
    }

    private static URI parseToURI(String redirectUrl) {
        try {
            return new URI(redirectUrl);
        }
        catch (URISyntaxException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static @Nullable User getOrAuthenticateUser(ContainerRequestContext requestContext, IStaticServiceContext staticServiceContext, Providers providers) {
        User user = AuthenticationFilter.getUser(requestContext);
        if (user != null) {
            return user;
        }
        return AuthenticationFilter.authenticateUser(requestContext, staticServiceContext, providers);
    }

    private static @Nullable User authenticateUser(ContainerRequestContext requestContext, IStaticServiceContext staticServiceContext, Providers providers) {
        return staticServiceContext.getAuthenticationRequestHandler().authenticate(requestContext, (IMultiPartFormDataProvider)new JaxRsFormDataProvider(requestContext, providers));
    }

    public static @Nullable User getUser(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (securityContext instanceof BasicSecurityContext) {
            return ((BasicSecurityContext)securityContext).getUserPrincipal().getUser();
        }
        return null;
    }
}

