/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.handler;

import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.service.framework.ServerStartFailedException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class HTTPSUtils {
    private static final String WEAK_CIPHER_SYSTEM_PROPERTY = "com.teamscale.ssl.allow-weak-ciphers";
    private static final String SKIP_SNI_HOST_CHECK_SYSTEM_PROPERTY = "com.teamscale.ssl.skip-sni-host-check";

    HTTPSUtils() {
    }

    public static void enableHTTPS(Server server, ServerConfiguration serverConfiguration) throws ServerStartFailedException {
        SslContextFactory.Server sslContextFactory = HTTPSUtils.createSslContextFactory();
        HTTPSUtils.validateHttpsKeyStore(serverConfiguration);
        File keyStoreFile = new File(FileSystemUtils.normalizeSeparators((String)serverConfiguration.getKeyStorePath()));
        String keyStorePassword = serverConfiguration.getKeyStorePassword();
        String certificateAlias = serverConfiguration.getCertificateAlias();
        URI keyStoreUri = keyStoreFile.toURI();
        sslContextFactory.setKeyStorePath(keyStoreUri.toString());
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        sslContextFactory.setCertAlias(certificateAlias);
        sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
        HttpConfiguration httpsConfiguration = new HttpConfiguration();
        httpsConfiguration.setSendServerVersion(false);
        httpsConfiguration.setUriCompliance(UriCompliance.UNSAFE);
        httpsConfiguration.setSecurePort(serverConfiguration.getHttpsPort());
        httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(!Boolean.getBoolean(SKIP_SNI_HOST_CHECK_SYSTEM_PROPERTY)));
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpsConfiguration);
        HTTP2ServerConnectionFactory http2Factory = new HTTP2ServerConnectionFactory(httpsConfiguration);
        ALPNServerConnectionFactory alpnFactory = new ALPNServerConnectionFactory(new String[0]);
        alpnFactory.setDefaultProtocol(httpFactory.getProtocol());
        SslConnectionFactory sslFactory = new SslConnectionFactory(sslContextFactory, alpnFactory.getProtocol());
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{sslFactory, alpnFactory, http2Factory, httpFactory});
        serverConnector.setPort(serverConfiguration.getHttpsPort());
        String host = serverConfiguration.getBindHostname();
        if (!StringUtils.isEmpty((String)host)) {
            serverConnector.setHost(host);
        }
        server.addConnector((Connector)serverConnector);
    }

    private static SslContextFactory.Server createSslContextFactory() {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (Boolean.getBoolean(WEAK_CIPHER_SYSTEM_PROPERTY)) {
            sslContextFactory.setExcludeCipherSuites(new String[0]);
        } else {
            sslContextFactory.addExcludeCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"});
        }
        return sslContextFactory;
    }

    private static void validateHttpsKeyStore(ServerConfiguration serverConfiguration) {
        try {
            serverConfiguration.loadHttpsKeyStore();
        }
        catch (IOException e) {
            throw new ServerStartFailedException((Throwable)e);
        }
    }
}

