/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.MDLSectionBase;

class MDLSection
extends MDLSectionBase {
    private MDLSection parentSection;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final ListMap<String, MDLSection> subSections = new ListMap();

    MDLSection(String name, int lineNumber) {
        super(name, lineNumber);
    }

    MDLSection(String name, List<MDLSection> sections, PairList<String, String> parameters, int lineNumber) {
        this(name, lineNumber);
        for (MDLSection section : sections) {
            this.addSubSection(section);
        }
        for (int i = 0; i < parameters.size(); ++i) {
            if (parameters.getSecond(i) == null) continue;
            this.parameters.put((String)parameters.getFirst(i), (String)parameters.getSecond(i));
        }
    }

    private void addSubSection(MDLSection section) {
        section.parentSection = this;
        this.subSections.add((Object)section.getName(), (Object)section);
    }

    public MDLSection getParentSection() {
        return this.parentSection;
    }

    public MDLSection getFirstSubSection(String name) {
        if (!this.hasSubSections(name)) {
            return null;
        }
        return (MDLSection)((List)this.subSections.getCollection((Object)name)).get(0);
    }

    public List<MDLSection> getLeafSections() {
        ArrayList<MDLSection> result = new ArrayList<MDLSection>();
        for (MDLSection section : (List)this.subSections.getValues()) {
            this.collectLeafSections(section, result);
        }
        return result;
    }

    public List<MDLSection> getLeafSections(String name) {
        ArrayList<MDLSection> result = new ArrayList<MDLSection>();
        for (MDLSection section : this.getLeafSections()) {
            if (!section.getName().equals(name)) continue;
            result.add(section);
        }
        return result;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String getParameter(String name, String defaultValue) {
        if (!this.parameters.containsKey(name)) {
            return defaultValue;
        }
        return this.parameters.get(name);
    }

    public Map<String, String> getParameterMapRecursively() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.buildParameterMap(map, "");
        return map;
    }

    public UnmodifiableSet<String> getParameterNames() {
        return CollectionUtils.asUnmodifiable(this.parameters.keySet());
    }

    public UnmodifiableList<MDLSection> getSubSections() {
        return CollectionUtils.asUnmodifiable((List)((List)this.subSections.getValues()));
    }

    public UnmodifiableList<MDLSection> getSubSections(String name) {
        if (!this.hasSubSections(name)) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable((List)((List)this.subSections.getCollection((Object)name)));
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public boolean hasSubSections(String name) {
        return this.subSections.containsCollection((Object)name) && !((List)this.subSections.getCollection((Object)name)).isEmpty();
    }

    private void buildParameterMap(Map<String, String> map, String prefix) {
        if (!StringUtils.isEmpty((String)prefix)) {
            prefix = (String)prefix + ".";
        }
        for (String name : this.parameters.keySet()) {
            map.put((String)prefix + name, this.parameters.get(name));
        }
        for (MDLSection subSection : this.getSubSections()) {
            subSection.buildParameterMap(map, (String)prefix + subSection.getName());
        }
    }

    private void collectLeafSections(MDLSection section, ArrayList<MDLSection> result) {
        if (!section.hasSubSections()) {
            result.add(section);
            return;
        }
        for (MDLSection child : section.getSubSections()) {
            this.collectLeafSections(child, result);
        }
    }

    private boolean hasSubSections() {
        return this.subSections.getValueCount() > 0;
    }

    public void removeSubSections(String sectionName) {
        this.subSections.removeCollection((Object)sectionName);
    }

    public String getTreeAsString() {
        StringBuilder builder = new StringBuilder();
        this.appendTreeReprentation(builder, 0);
        return builder.toString();
    }

    private void appendTreeReprentation(StringBuilder builder, int indentation) {
        for (int i = 0; i < indentation; ++i) {
            builder.append("  ");
        }
        builder.append(this.getName() + " (" + this.getLineNumber() + "): " + this.getParameter("Name"));
        builder.append(StringUtils.LINE_SEPARATOR);
        for (MDLSection subsection : this.getSubSections()) {
            subsection.appendTreeReprentation(builder, indentation + 1);
        }
    }

    public String getMatlabReleaseVersionName() {
        UnmodifiableList<MDLSection> subSections = this.getSubSections("matlabRelease");
        if (subSections.isEmpty()) {
            return "";
        }
        return ((MDLSection)subSections.get(0)).getParameter("MatlabReleaseVersion");
    }
}

