/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.ResolvedIdUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkObject;
import org.conqat.lib.simulink.util.SimulinkUtils;

public abstract class SimulinkElementBase
extends ParameterizedElement {
    private SimulinkElementBase parent;
    private final Set<SimulinkObject> objects = new IdentityHashSet();

    protected SimulinkElementBase() {
    }

    protected SimulinkElementBase(SimulinkElementBase other) {
        super(other);
        this.parent = other.parent;
        this.objects.addAll(other.objects);
    }

    public String getId() {
        return SimulinkUtils.buildId(this.parent, this.getName());
    }

    public List<String> getSplitId() {
        if (this.parent != null) {
            List<String> splitId = this.parent.getSplitId();
            splitId.add(this.getName());
            return splitId;
        }
        return new ArrayList<String>(Collections.singletonList(this.getName()));
    }

    @Deprecated
    public String getResolvedId() {
        return new ResolvedIdUtils().getResolvedId(this);
    }

    @Deprecated
    public List<String> getSplitResolvedIdWithResolvedLabels() {
        return new ResolvedIdUtils().getSplitResolvedIdWithResolvedLabels(this);
    }

    @Deprecated
    public String getResolvedIdWithResolvedLabels() {
        return new ResolvedIdUtils().getResolvedIdWithResolvedLabels(this);
    }

    public SimulinkModel getModel() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getModel();
    }

    public String getName() {
        return this.getParameter("Name");
    }

    public String getNameUnescapeNewLineChars() {
        return this.getParameterUnescapeNewLineChars("Name");
    }

    public SimulinkElementBase getParent() {
        return this.parent;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeElement(this);
            this.parent = null;
        }
        for (SimulinkObject object : new ArrayList<SimulinkObject>(this.objects)) {
            object.remove();
        }
    }

    protected void removeElement(SimulinkElementBase element) {
        if (element instanceof SimulinkObject) {
            this.objects.remove(element);
        } else {
            CCSMAssert.fail((String)(element.getClass().getName() + " is an unknown sub class of " + SimulinkElementBase.class.getName()));
        }
    }

    public String toString() {
        return this.getName();
    }

    public void setParent(SimulinkElementBase parent) {
        CCSMAssert.isTrue((this.parent == null ? 1 : 0) != 0, (String)"Element already has a parent!");
        CCSMAssert.isFalse((parent == null ? 1 : 0) != 0, (String)"Parent cannot be null!");
        this.parent = parent;
    }

    public void overrideParent(SimulinkElementBase parent) {
        this.parent = null;
        this.setParent(parent);
    }

    public void addObject(SimulinkObject object) {
        this.objects.add(object);
        object.setParent(this);
    }

    public UnmodifiableSet<SimulinkObject> getObjects() {
        return CollectionUtils.asUnmodifiable(this.objects);
    }
}

