/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.simulink.builder.SimulinkPortBuilder;
import org.conqat.lib.simulink.model.FlexiblePortPlacementParameters;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkPortBase;

public class SimulinkInPort
extends SimulinkPortBase {
    private SimulinkLine line;

    public SimulinkInPort(SimulinkBlock block, SimulinkPortBuilder.EPortType portType, String index, FlexiblePortPlacementParameters flexiblePortPlacementParameters) {
        super(block, portType, index, flexiblePortPlacementParameters);
        block.addInPort(this);
    }

    public SimulinkLine getLine() {
        return this.line;
    }

    void setLine(SimulinkLine line) throws IllegalArgumentException {
        CCSMAssert.isTrue((this.line == null ? 1 : 0) != 0, (String)"Port already has a line");
        CCSMAssert.isTrue((line.getDstPort() == this ? 1 : 0) != 0, (String)"Line's port does not match.");
        this.line = line;
    }

    @Override
    public Optional<String> getSignalName() {
        if (this.line == null) {
            return Optional.empty();
        }
        return this.line.getName();
    }

    void removeLine(SimulinkLine line) throws IllegalArgumentException {
        CCSMAssert.isTrue((line != null ? 1 : 0) != 0, (String)"Can not remove null line.");
        CCSMAssert.isTrue((line == this.line ? 1 : 0) != 0, (String)"Line does not belong to this port.");
        this.line = null;
    }

    @Override
    public void remove() {
        this.getBlock().removeInPort(this);
        if (this.line != null) {
            this.line.remove();
        }
        super.remove();
    }

    @Override
    public boolean isConnected() {
        return this.line != null;
    }

    public boolean isTriggerPort() {
        return "trigger".equals(this.getIndex());
    }

    public boolean isEnablePort() {
        return "enable".equals(this.getIndex());
    }

    public boolean isResetPort() {
        return "Reset".equals(this.getIndex());
    }

    public boolean isActionPort() {
        return "ifaction".equals(this.getIndex());
    }

    public boolean isStatePort() {
        return this.getIndex().equals("state");
    }

    @Override
    public boolean isSpecialPort() {
        return this.isEnablePort() || this.isTriggerPort() || this.isResetPort() || this.isActionPort() || this.isStatePort();
    }
}

