/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.datahandler.simulink;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPortBase;
import org.conqat.lib.simulink.model.datahandler.BlockLayoutData;
import org.conqat.lib.simulink.model.datahandler.EOrientation;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.ui.SimulinkLabelOnBlockData;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SimulinkBlockLabelUtils {
    private static final Set<String> OUT_DATA_TYPE_PASS_THROUGH = CollectionUtils.asHashSet((Object[])new String[]{"double", "single", "int8", "uint8", "int16", "uint16", "int32", "uint32", "boolean"});
    private static final String FRACTION_LINE_PLACEHOLDER = "$FRAC$";

    public static boolean labelFitsInsideBlock(SimulinkBlock block) {
        String labelText = SimulinkLabelOnBlockData.getLabelText(block);
        return SimulinkBlockLabelUtils.labelFitsInsideBlock(labelText, block);
    }

    public static boolean labelFitsInsideBlock(String labelText, SimulinkBlock block) {
        Font blockFont = block.obtainLabelLayoutData().getFont().getAwtFont();
        int labelWidth = 0;
        if (labelText != null) {
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
            labelWidth = (int)blockFont.getStringBounds(labelText, fontRenderContext).getWidth();
        }
        return (double)labelWidth <= SimulinkBlockLabelUtils.getAvailableWidth(block);
    }

    private static double getAvailableWidth(SimulinkBlock block) {
        BlockLayoutData blockLayoutData = block.obtainBlockLayoutData();
        if (!block.isOfType("Gain")) {
            return blockLayoutData.getPosition().getWidth();
        }
        if (blockLayoutData.getOrientation() == EOrientation.RIGHT || blockLayoutData.getOrientation() == EOrientation.LEFT) {
            return blockLayoutData.getPosition().getWidth();
        }
        Rectangle position = blockLayoutData.getPosition();
        Point vertex1 = new Point(position.x, position.y);
        Point vertex2 = new Point(position.x, position.y - position.height);
        Point vertex3 = new Point(position.x + position.width, position.y - position.height / 2);
        Point centroid = new Point((vertex1.x + vertex2.x + vertex3.x) / 3, (vertex1.y + vertex2.y + vertex3.y) / 3);
        return (1.0 - (double)(centroid.x - position.x) / position.getWidth()) * position.getHeight();
    }

    public static String determineActionPortData(SimulinkBlock block) {
        String actionType = block.getParameter("ActionType");
        if ("unset".equals(actionType)) {
            return "Action";
        }
        if ("then".equals(actionType)) {
            return "if {}";
        }
        return actionType + " {}";
    }

    public static String obtainDataTypeConversionBlockData(SimulinkBlock block) {
        boolean storedInteger = StringUtils.emptyIfNull((String)block.getParameter("ConvertRealWorld")).contains("Stored Integer");
        String outDataSrc = block.getParameter("OutDataTypeStr");
        Object result = OUT_DATA_TYPE_PASS_THROUGH.contains(outDataSrc) ? outDataSrc : "Convert";
        if (storedInteger) {
            result = (String)result + "\n(SI)";
        }
        return result;
    }

    public static String obtainPermuteDimensionsBlockData(SimulinkBlock block) {
        String order = block.getParameter("Order");
        return "P:" + order;
    }

    public static String obtainTriggerPortBlockData(SimulinkBlock block) {
        if ("function-call".equals(block.getParameter("TriggerType"))) {
            return "f()";
        }
        return null;
    }

    public static String obtainAssignmenOrSelectortBlockData(SimulinkBlock block, String inputText) {
        String dimensions = block.getParameter("NumberOfDimensions");
        String inputPortSize = block.getParameter("InputPortWidth");
        String indices = StringUtils.emptyIfNull((String)block.getParameter("Indices")).replaceAll("\\s+", ",").replaceAll("[\\[\\]]", "").replaceAll("^,|,$", "");
        if ("1".equals(dimensions) && block.getInPorts().size() == 1 && !"-1".equals(inputPortSize) && indices.matches("[0-9,]+")) {
            int index = 0;
            if ("One-based".equals(block.getParameter("IndexMode"))) {
                index = 1;
            }
            return inputPortSize + "*" + indices + "*" + index;
        }
        return dimensions + "-D\n" + inputText;
    }

    public static String obtainReshapeBlockData(SimulinkBlock block) {
        String dimensionality = block.getParameter("OutputDimensionality");
        if ("1-D array".equals(dimensionality)) {
            return "U( : )";
        }
        if ("Customize".equals(dimensionality) || "Derive from reference input port".equals(dimensionality)) {
            return "Reshape";
        }
        return null;
    }

    public static String obtainRealImagToComplexBlockData(SimulinkBlock block) {
        String input = block.getParameter("Input");
        if ("real".equalsIgnoreCase(input)) {
            return "u + j K";
        }
        if ("Imag".equals(input)) {
            return "K + j u";
        }
        return null;
    }

    public static String obtainMathBlockData(SimulinkBlock block) {
        String operator = block.getParameter("Operator");
        if ("log10".equals(operator) || "hypot".equals(operator) || "rem".equals(operator) || "mod".equals(operator)) {
            return operator;
        }
        if ("log".equals(operator)) {
            return "ln";
        }
        return null;
    }

    public static String obtainComplexToRealImagBlockData(SimulinkBlock block) {
        String output = block.getParameter("Output");
        if ("real".equalsIgnoreCase(output)) {
            return "Re(u)";
        }
        if ("Imag".equals(output)) {
            return "Im(u)";
        }
        return "";
    }

    public static String obtainComplexToMagnitudeAngleBlockData(SimulinkBlock block) {
        String output = block.getParameter("Output");
        if ("Magnitude".equals(output)) {
            return "|u|";
        }
        return "";
    }

    public static String obtainSampleTimeMathBlockData(SimulinkBlock block) {
        String operator = block.getParameter("TsampMathOp");
        Object result = "";
        result = "Ts Only".equals(operator) ? (String)result + "Ts" : ("1/Ts Only".equals(operator) ? (String)result + "1/Ts" : (String)result + "u" + operator + "Ts");
        String weightValue = block.getParameter("weightValue");
        if (weightValue == null) {
            return result;
        }
        try {
            float weight = Float.parseFloat(weightValue);
            if (weight != 1.0f) {
                result = "1/Ts Only".equals(operator) || "/".equals(operator) ? (String)result + "/w" : (String)result + "*w";
            }
            return result;
        }
        catch (NumberFormatException e) {
            return result;
        }
    }

    public static String obtainLogicBlockTextLabel(SimulinkBlock block) {
        String iconShape = block.getParameter("IconShape");
        String operator = block.getParameter("Operator");
        if ("distinctive".equals(iconShape)) {
            return "D" + operator;
        }
        return operator;
    }

    public static String obtainBiasBlockData(SimulinkBlock block) {
        return "u+" + block.getParameter("Bias");
    }

    public static String obtainLookupNDBlockcData(SimulinkBlock block) {
        String dimensions = block.getParameter("NumberOfTableDimensions");
        return dimensions + "-D T[k]";
    }

    public static String getWhileIteratorBlockData(SimulinkBlock block) {
        String whileBlockType = block.getParameter("WhileBlockType");
        if ("do-while".equals(whileBlockType)) {
            return "do {\n ...\n} while";
        }
        return "while {\n ...\n}";
    }

    public static String getSubSystemBlockData(SimulinkBlock block) {
        if (block.hasSubBlockOfType("ForIterator") != null) {
            return "for { ... }";
        }
        SimulinkBlock whileSubBlock = block.hasSubBlockOfType("WhileIterator");
        if (whileSubBlock != null) {
            if ("do-while".equals(whileSubBlock.getParameter("WhileBlockType"))) {
                return "do { ... } while";
            }
            return "while {\n ...\n}";
        }
        SimulinkBlock eventListenerBlock = block.hasSubBlockOfType("EventListener");
        if (eventListenerBlock != null) {
            return eventListenerBlock.getParameter("EventType");
        }
        return "";
    }

    public static String getSubSystemBlockIcon(SimulinkBlock block) {
        if (block.isStateflowChartBlock()) {
            return "stateflow_chart_icon.png";
        }
        if (block.hasSubBlockOfType("ForEach") != null) {
            return "for_each_subsystem.png";
        }
        return null;
    }

    public static String getDisplayBlockFormat(SimulinkBlock block) {
        String format = block.getParameter("Format");
        if ("long".equals(format)) {
            return "long";
        }
        return "short";
    }

    public static String obtainMuxBlockData(SimulinkBlock block) {
        String displayOption = block.getParameter("DisplayOption");
        if ("none".equals(displayOption)) {
            return block.getType();
        }
        return null;
    }

    public static String obtainGainBlockData(SimulinkBlock block) {
        String mult = block.getParameter("Multiplication");
        if (mult == null) {
            return block.getParameter("Gain".toLowerCase());
        }
        String gain = block.getParameter("Gain");
        switch (mult) {
            case "Matrix(K*u)": {
                return gain + "* u";
            }
            case "Matrix(u*K)": {
                return "u *" + gain;
            }
            case "Matrix(K*u) (u vector)": {
                return gain + "* uvec";
            }
        }
        return gain;
    }

    public static String obtainArithShiftData(SimulinkBlock block) {
        int value;
        String shiftSign;
        String direction = block.getParameter("BitShiftDirection");
        String source = block.getParameter("BitShiftNumberSource");
        if ("Input port".equals(source)) {
            switch (direction) {
                case "Left": {
                    return "Qu<<s";
                }
                case "Right": {
                    return "Qu>>s";
                }
            }
            return "Shift";
        }
        String binPoints = block.getParameter("BinPtShiftNumber");
        String shiftBits = block.getParameter("BitShiftNumber");
        if (binPoints == null || shiftBits == null) {
            return "Qy = Qu >> 8\nVy = Vu * 2^-8\nEy = Eu";
        }
        if ("Left".equals(direction)) {
            shiftSign = "<<";
            value = Integer.parseInt(binPoints) + Integer.parseInt(shiftBits);
        } else {
            shiftSign = ">>";
            value = Integer.parseInt(binPoints) - Integer.parseInt(shiftBits);
        }
        return "Qy = Qu " + shiftSign + " " + shiftBits + "\nVy = Vu * 2^" + value + "\nEy = Eu + " + binPoints;
    }

    public static String obtainSignalSpecificationData(SimulinkBlock block) {
        String dataType = block.getParameter("OutDataTypeStr");
        String signalType = block.getParameter("SignalType");
        String samplingMode = block.getParameter("SamplingMode");
        return SimulinkBlockLabelUtils.determineSignalSpecificationData(dataType, signalType, samplingMode);
    }

    public static String obtainGotoFromBlockLabel(SimulinkBlock block) {
        String display = StringUtils.emptyIfNull((String)block.getParameter("IconDisplay"));
        String tag = block.getParameter("GotoTag");
        switch (display) {
            case "Signal name": {
                return "<" + SimulinkBlockLabelUtils.determineGotoFromSignalName(block).orElse(" ") + ">";
            }
            case "Tag and signal name": {
                if (tag == null) break;
                return "[" + tag + "<" + SimulinkBlockLabelUtils.determineGotoFromSignalName(block).orElse(" ") + ">]";
            }
            default: {
                if (tag == null) break;
                return "[" + tag + "]";
            }
        }
        return null;
    }

    @VisibleForTesting
    public static Optional<String> determineGotoFromSignalName(SimulinkBlock block) {
        if (!block.getOutPorts().isEmpty()) {
            return Objects.requireNonNull((SimulinkOutPort)CollectionUtils.getAny(block.getOutPorts())).getSignalName();
        }
        if (!block.getInPorts().isEmpty()) {
            return Objects.requireNonNull((SimulinkInPort)CollectionUtils.getAny(block.getInPorts())).getSignalName();
        }
        return Optional.empty();
    }

    public static String determineSignalSpecificationData(String dataType, String signalType, String samplingMode) {
        if (StringUtils.emptyIfNull((String)dataType).contains("Bus")) {
            return "Dt:" + dataType + " BT:VB";
        }
        String result = "";
        if ("Inherit: auto".equals(dataType)) {
            if ("auto".equals(signalType) && "auto".equals(samplingMode)) {
                result = result.concat("inherit");
            }
        } else {
            result = result.concat("Dt:" + dataType);
        }
        if (!"auto".equals(signalType)) {
            result = "real".equals(signalType) ? result.concat(" C:0") : result.concat(" C:1");
        }
        if (!"auto".equals(samplingMode)) {
            result = "Sample based".equals(samplingMode) ? result.concat(" S:S") : result.concat(" S:F");
        }
        return result;
    }

    public static String obtainMinMaxResettableBlockData(SimulinkBlock block) {
        String function = block.getParameter("Function");
        return function + "(u,y)";
    }

    public static String obtainCompareToConstantBlockData(SimulinkBlock block) {
        return block.getParameter("relop") + " " + block.getParameter("const");
    }

    public static String obtainCompareToZeroBlockData(SimulinkBlock block) {
        return block.getParameter("relop") + " 0";
    }

    public static String obtainFunctionCallGeneratorBlockData(SimulinkBlock block) {
        String iterations = block.getParameter("numberOfIterations");
        if ("1".equals(iterations)) {
            return "f()";
        }
        return "iterate I = 1:" + iterations;
    }

    public static String obtainBitwiseOperatorBlockData(SimulinkBlock block) {
        String operator = block.getParameter("logicop");
        String result = "Bitwise\n" + operator;
        String useBitMask = block.getParameter("UseBitMask");
        if ("on".equals(useBitMask)) {
            result = result + "\nMask";
        }
        return result;
    }

    public static String obtainExtractBitsBlockData(SimulinkBlock block) {
        String bitsToExtract;
        switch (bitsToExtract = block.getParameter("bitsToExtract")) {
            case "Upper half": {
                return "Extract Bits\nUpper Half";
            }
            case "Lower half": {
                return "Extract Bits\nLower Half";
            }
            case "Range starting with most significant bit": {
                return "Extract " + block.getParameter("numBits") + " Bits\nUpper End";
            }
            case "Range ending with least significant bit": {
                return "Extract " + block.getParameter("numBits") + " Bits\nLower End";
            }
            case "Range of bits": {
                return "Extract Bits\n" + block.getParameter("bitIdxRange");
            }
        }
        return "";
    }

    public static String obtainConcatenateIcon(SimulinkBlock block) {
        String mode = block.getParameter("Mode");
        if ("Multidimensional array".equals(mode)) {
            return "matrix_concatenate.png";
        }
        return null;
    }

    public static String obtainManualSwitchIcon(SimulinkBlock block) {
        String currentSetting = block.getParameter("CurrentSetting");
        if ("0".equals(currentSetting)) {
            return "manual_switch_0.png";
        }
        return "manual_switch_1.png";
    }

    public static String obtainDiscretePulseGeneratorIcon(SimulinkBlock block) {
        String pulseType = block.getParameter("PulseType");
        if ("Sample based".equals(pulseType)) {
            if (block.getInPorts().size() == 1) {
                return "pulse_generator_sample_t.png";
            }
            return "pulse_generator_sample.png";
        }
        if (block.getInPorts().size() == 1) {
            return "pulse_generator_time_t.png";
        }
        return "pulse_generator_time.png";
    }

    public static String obtainProductBlockIcon(SimulinkBlock block) {
        String inputs = StringUtils.emptyIfNull((String)block.getParameter("Inputs"));
        String multType = block.getParameter("Multiplication");
        if (inputs.length() == 1 && !"Matrix(*)".equals(multType)) {
            if (inputs.equals("*") || inputs.equals("1")) {
                return "product.png";
            }
            if (inputs.equals("/")) {
                return "product_divide.png";
            }
        }
        return null;
    }

    public static String obtainSumBlockIcon(SimulinkBlock block) {
        String inputs = StringUtils.emptyIfNull((String)block.getParameter("Inputs"));
        if (inputs.length() == 1) {
            switch (inputs) {
                case "+": {
                    return "sum_sigma.png";
                }
                case "-": {
                    return "minus_sum_sigma.png";
                }
            }
            return null;
        }
        return null;
    }

    public static String obtainReshapeBlockIcon(SimulinkBlock block) {
        String dimensionality = block.getParameter("OutputDimensionality");
        if ("Column vector (2-D)".equals(dimensionality)) {
            return "reshape_column.png";
        }
        if ("Row vector (2-D)".equals(dimensionality)) {
            return "reshape_row.png";
        }
        return null;
    }

    public static String obtainComplexBlocksIcons(String parameter, List<String> iconOptions) {
        if ("Magnitude".equals(parameter) || "Real and imag".equals(parameter)) {
            return iconOptions.get(0);
        }
        if ("Angle".equals(parameter)) {
            return iconOptions.get(1);
        }
        if ("Magnitude and angle".equals(parameter)) {
            return iconOptions.get(2);
        }
        return "";
    }

    public static String obtainMathBlockIcon(SimulinkBlock block) {
        String operator = block.getParameter("Operator");
        if (operator == null) {
            return null;
        }
        switch (operator) {
            case "10^u": {
                return "Math_10u.png";
            }
            case "magnitude^2": {
                return "mag2.png";
            }
            case "square": {
                return "square.png";
            }
            case "pow": {
                return "pow.png";
            }
            case "conj": {
                return "conj.png";
            }
            case "reciprocal": {
                return "reciprocal.png";
            }
            case "transpose": {
                return "transpose.png";
            }
            case "hermitian": {
                return "hermitian.png";
            }
            case "exp": {
                return "exp.png";
            }
        }
        return null;
    }

    public static String obtainStateReaderWriterBlockData(SimulinkBlock block) {
        SimulinkBlock parent;
        String blockPath = block.getParameter("StateOwnerBlock");
        if (blockPath == null) {
            return null;
        }
        for (parent = block; blockPath.startsWith("../") && parent != null; parent = parent.getParent()) {
            blockPath = blockPath.substring(3);
        }
        if (parent == null) {
            return null;
        }
        SimulinkBlock stateOwnerBlock = parent.getSubBlockWithWhitespaceNormalization(blockPath);
        if (stateOwnerBlock == null) {
            return null;
        }
        String stringIdentifier = stateOwnerBlock.getParameter("StateIdentifier");
        if (stringIdentifier == null) {
            stringIdentifier = stateOwnerBlock.getParameter("StateName");
        }
        return stringIdentifier;
    }

    public static String obtainSqrtBlockIcon(SimulinkBlock block) {
        String operator = block.getParameter("Operator");
        if ("rSqrt".equals(operator)) {
            return "rSqrt.png";
        }
        if ("signedSqrt".equals(operator)) {
            return "signedSqrt.png";
        }
        return "sqrt.png";
    }

    public static String obtainPreLookupBlockIcon(SimulinkBlock block) {
        String dataSrc = block.getParameter("BreakpointsDataSource");
        String onlyIndex = block.getParameter("OutputOnlyTheIndex");
        if ("Dialog".equals(dataSrc)) {
            if ("on".equals(onlyIndex)) {
                return "prelookup_dialog_index.png";
            }
            return "prelookup_dialog_fraction.png";
        }
        if ("on".equals(onlyIndex)) {
            return "prelookup_inport_index.png";
        }
        return "prelookup_inport_fraction.png";
    }

    public static String obtainNDLookupBlockIcon(SimulinkBlock block) {
        String inputObject = block.getParameter("InputsSelectThisObjectFromTable");
        if ("Column".equals(inputObject)) {
            return "ndlookup_column.png";
        }
        if ("2-D Matrix".equals(inputObject)) {
            return "ndlookup_matrix.png";
        }
        String dimensions = block.getParameter("NumberOfTableDimensions");
        if (dimensions == null) {
            return null;
        }
        switch (dimensions) {
            case "1": {
                return "ndlookup_1element.png";
            }
            case "2": {
                return "ndlookup_2element.png";
            }
            case "3": {
                return "ndlookup_3element.png";
            }
        }
        return "ndlookup_4element.png";
    }

    public static String obtainStepBlockIcon(SimulinkBlock block) {
        int after;
        String beforeParam = block.getParameter("Before");
        String afterParam = block.getParameter("After");
        if (beforeParam == null || afterParam == null) {
            return null;
        }
        int before = Integer.parseInt(beforeParam);
        if (before > (after = Integer.parseInt(afterParam))) {
            return "step_decrease.png";
        }
        return "step_increase.png";
    }

    public static String obtainAssertionBlockIcon(SimulinkBlock block) {
        String enabled = block.getParameter("Enabled");
        if ("off".equals(enabled)) {
            return "assertion_disabled.png";
        }
        return "assertion_enabled.png";
    }

    public static String obtainReferenceBlockIcon(SimulinkBlock block) {
        String sourceType = block.getParameter("SourceType");
        String sourceBlock = block.getSourceBlockName();
        if (sourceType.contains("Unit Delay")) {
            return "unit_delay.png";
        }
        if (sourceBlock.contains("BACE_UnitDelay")) {
            return "bace_unit_delay.png";
        }
        if (sourceType.contains("TurnOnDelay")) {
            return "bace_turn_on_delay.png";
        }
        if (sourceType.contains("TurnOffDelay")) {
            return "bace_turn_off_delay.png";
        }
        if (sourceBlock.contains("BACE") && (sourceBlock.contains("ArraySum") || sourceBlock.contains("ArrayMean"))) {
            return "bace_array_" + sourceBlock.split("/")[1].split("Array")[1].toLowerCase() + ".png";
        }
        if (sourceBlock.contains("BACE_DiscreteTimeIntegrator")) {
            return "bace_discrete_time_integrator.png";
        }
        if (sourceBlock.contains("BACE") && sourceBlock.contains("Integrator")) {
            return "bace_integrator.png";
        }
        return null;
    }

    public static String obtainMuxBlockIcon(SimulinkBlock block) {
        String displayOption = block.getParameter("DisplayOption");
        if ("bar".equals(displayOption)) {
            return "mux_bar.png";
        }
        return null;
    }

    public static String obtainTriggerPortBlockIcon(SimulinkBlock block) {
        String triggerType = block.getParameter("TriggerType");
        if ("rising".equals(triggerType)) {
            return "reset_rising.png";
        }
        if ("falling".equals(triggerType)) {
            return "reset_falling.png";
        }
        if ("either".equals(triggerType)) {
            return "reset_either.png";
        }
        return "";
    }

    public static String obtainIntegratorBlockIcon(SimulinkBlock block) {
        String limitOutputParam = block.getParameter("LimitOutput");
        String wrapStateParam = block.getParameter("WrapState");
        String iconFileName = "on".equals(limitOutputParam) ? "integrator_limit.png" : ("on".equals(wrapStateParam) ? "integrator_wrap.png" : "integrator.png");
        return iconFileName;
    }

    public static String obtainSignalConversionData(SimulinkBlock block) {
        String conversionOutput = block.getParameter("ConversionOutput");
        if ("Virtual bus".equals(conversionOutput)) {
            return "virtual_bus.png";
        }
        if ("Nonvirtual bus".equals(conversionOutput)) {
            return "nonvirtual_bus.png";
        }
        return "signal_copy.png";
    }

    public static String obtainProductData(SimulinkBlock block) {
        String multType = block.getParameter("Multiplication");
        String inputs = block.getParameter("Inputs");
        if (multType == null || inputs == null) {
            return null;
        }
        if ("Matrix(*)".equals(multType)) {
            if ("/".equals(inputs)) {
                return null;
            }
            try {
                Integer.parseInt(inputs);
                return "Matrix\nMultiply";
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            int numberOfInputs = Integer.parseInt(inputs);
            if (numberOfInputs == 1) {
                return null;
            }
            return "x";
        }
        catch (NumberFormatException e) {
            if (!inputs.contains("/") && inputs.length() > 1) {
                return "x";
            }
            return null;
        }
    }

    public static String obtainDelayData(SimulinkBlock block) {
        if ("Dialog".equals(block.getParameter("DelayLengthSource"))) {
            String delayLength = block.getParameter("DelayLength");
            return "Z^(-" + delayLength + ")";
        }
        return "Z^(-d)";
    }

    public static String determineTextForSwitch(SimulinkBlock block) {
        String criterion = block.getParameter("Criteria");
        if ((criterion = criterion.replace("u2 ", "")).contains("Threshold")) {
            criterion = criterion.replace("Threshold", "");
            String threshold = block.getParameter("Threshold");
            return criterion + threshold;
        }
        return criterion;
    }

    public static String determineTextForPorts(SimulinkBlock block) {
        String portLabel = "";
        String paramIconDisplay = block.getParameter("IconDisplay");
        SimulinkPortBase port = SimulinkBlockLabelUtils.getPort(block);
        String paramPort = block.getParameter("Port");
        if (paramPort != null) {
            portLabel = paramPort;
        } else if (port != null) {
            portLabel = port.getParameter("PortNumber");
        }
        if ("Port number".equals(paramIconDisplay)) {
            return portLabel;
        }
        String signalName = SimulinkBlockLabelUtils.getPortSignalName(block);
        if (paramIconDisplay != null && paramIconDisplay.contains("Port number")) {
            if (signalName == null) {
                return portLabel;
            }
            return portLabel + "." + block.formatSignalName(signalName);
        }
        if (signalName == null) {
            return portLabel;
        }
        return block.formatSignalName(signalName);
    }

    private static String getPortSignalName(SimulinkBlock block) {
        SimulinkPortBase port = SimulinkBlockLabelUtils.getPort(block);
        if (port == null) {
            return null;
        }
        String signalName = port.getSignalName().orElse(null);
        if (signalName != null) {
            return signalName;
        }
        SimulinkLine signalLine = null;
        if (SimulinkUtils.isInport(block) && block.getParent() != null && block.getParent().isOfType("SubSystem")) {
            String portIndex = block.getParameter("Port");
            if (portIndex == null) {
                return null;
            }
            SimulinkInPort subsystemInPort = block.getParent().getInPort(portIndex);
            if (subsystemInPort == null) {
                return null;
            }
            signalLine = subsystemInPort.getLine();
        } else if (SimulinkUtils.isOutport(block)) {
            signalLine = block.getInPort("1").getLine();
        }
        return SimulinkBlockLabelUtils.getSignalNameFromLine(signalLine, block.getModel());
    }

    private static String getSignalNameFromLine(SimulinkLine signalLine, SimulinkModel model) {
        if (signalLine == null) {
            return null;
        }
        SimulinkOutPort connectedPort = signalLine.getSrcPort();
        if (connectedPort == null) {
            return null;
        }
        if (SimulinkUtils.isFromBlock(connectedPort.getBlock())) {
            GotoFromResolver gotoFromResolver = new GotoFromResolver(model);
            List<SimulinkBlock> gotoBlocks = gotoFromResolver.getConnectedGotoBlocks(connectedPort.getBlock());
            for (SimulinkBlock gotoBlock : gotoBlocks) {
                SimulinkLine inLine = gotoBlock.getInPort("1").getLine();
                String signalName = SimulinkBlockLabelUtils.getSignalNameFromLine(inLine, model);
                if (signalName == null) continue;
                return signalName;
            }
        }
        if ("on".equals(connectedPort.getParameter("MustResolveToSignalObject"))) {
            return connectedPort.getParameter("Name");
        }
        return null;
    }

    public static SimulinkPortBase getPort(SimulinkBlock block) {
        if (SimulinkUtils.isInport(block)) {
            UnmodifiableCollection<SimulinkOutPort> ports = block.getOutPorts();
            CCSMAssert.isTrue((ports.size() == 1 ? 1 : 0) != 0, (String)("Expected Inport block " + block.getParameter("Name") + "to have exactly one port"));
            Object[] portsArray = new SimulinkPortBase[1];
            return ((SimulinkPortBase[])ports.toArray(portsArray))[0];
        }
        if (SimulinkUtils.isOutport(block)) {
            UnmodifiableCollection<SimulinkInPort> ports = block.getInPorts();
            CCSMAssert.isTrue((ports.size() == 1 ? 1 : 0) != 0, (String)("Expected Inport block " + block.getParameter("Name") + "to have exactly one port"));
            Object[] portsArray = new SimulinkPortBase[1];
            return ((SimulinkPortBase[])ports.toArray(portsArray))[0];
        }
        return null;
    }

    public static String obtainBmwFunctionCallGeneratorBlockData(SimulinkBlock block) {
        boolean state;
        boolean nkw = "on".equals(block.getParameter("nkw"));
        if (nkw ^ (state = "on".equals(block.getParameter("state")))) {
            return "bace_fcall_generator";
        }
        if (state) {
            return "???";
        }
        return null;
    }

    public static String obtainBitClearOrSetBlockData(SimulinkBlock block, String inputText) {
        String bit = block.getParameter("iBit");
        return inputText + "\nbit " + bit;
    }

    public static String obtainReferenceBlockLabelData(SimulinkBlock block) {
        String sourceBlock = block.getSourceBlockName();
        if (sourceBlock.contains("BACE") && (sourceBlock.contains("Mapping") || sourceBlock.contains("Unmap"))) {
            return sourceBlock.split("/")[1].replace("_", "\n");
        }
        if (sourceBlock.contains("putbit") || sourceBlock.contains("getbit") || sourceBlock.contains("setbit")) {
            return sourceBlock.split("/")[1];
        }
        if ("BACE_Fixpoint_Product/Safe Fixpoint Product".equals(sourceBlock)) {
            return "X";
        }
        if (sourceBlock.contains("BACE_RequireUnscaledVariable")) {
            return "NO\nFIXPOINT\nALLOWED";
        }
        if (sourceBlock.contains("BACE_PIDControl")) {
            return "PID\ncontrol";
        }
        return block.getParameter("MaskDisplayString");
    }

    public static String obtainBaceDivByZeroBlockData(SimulinkBlock block) {
        boolean useEps = "on".equals(block.getParameter("UseEpsilonComparison"));
        String labelText = "0";
        if (useEps) {
            labelText = "EPS";
        }
        return "PROTECT\nDIV-" + labelText;
    }

    public static String obtainDiscreteFilterBlockData(SimulinkBlock block) {
        String numeratorSource = block.getParameter("NumeratorSource");
        String denominatorSource = block.getParameter("DenominatorSource");
        if ("Input port".equals(numeratorSource) || "Input port".equals(denominatorSource)) {
            return "IIR";
        }
        return SimulinkBlockLabelUtils.getNumeratorDenominatorData(block);
    }

    private static String getNumeratorDenominatorData(SimulinkBlock block) {
        String numerator = block.getParameter("Numerator");
        String denominator = block.getParameter("Denominator");
        if (numerator == null || denominator == null) {
            return "";
        }
        String[] numeratorValues = numerator.replaceAll("[\\[\\]]", "").split(" ");
        String[] denominatorValues = denominator.replaceAll("[\\[\\]]", "").split(" ");
        boolean isTransferFunction = "DiscreteTransferFcn".equals(block.getType());
        String numeratorResult = SimulinkBlockLabelUtils.createDiscreteFilterFunction(numeratorValues, isTransferFunction);
        String denominatorResult = SimulinkBlockLabelUtils.createDiscreteFilterFunction(denominatorValues, isTransferFunction);
        return numeratorResult + "\n$FRAC$" + denominatorResult;
    }

    private static String createDiscreteFilterFunction(String[] coefficients, boolean isTransferFunction) {
        StringBuilder result = new StringBuilder(coefficients[0]);
        if (isTransferFunction) {
            result = new StringBuilder("z");
        }
        for (int i = 1; i < coefficients.length; ++i) {
            result.append("+").append(coefficients[i]);
            if (isTransferFunction) continue;
            result.append("z^(-").append(i).append(")");
        }
        return result.toString().replaceAll("\\^1", "");
    }

    public static String obtainDiscreteFirBlockData(SimulinkBlock block) {
        String coefficientSource = block.getParameter("CoefSource");
        if ("Input port".equals(coefficientSource)) {
            return "num(z)\n$FRAC$1";
        }
        String coefficientsParam = block.getParameter("Coefficients");
        if (coefficientsParam == null) {
            return "";
        }
        String[] coefficients = coefficientsParam.replaceAll("[\\[\\]]", "").split(" ");
        return SimulinkBlockLabelUtils.createDiscreteFilterFunction(coefficients, false) + "\n$FRAC$1";
    }

    public static String obtainDiscreteTransferFcnBlockData(SimulinkBlock block) {
        String numeratorSource = block.getParameter("NumeratorSource");
        String denominatorSource = block.getParameter("DenominatorSource");
        String initialStateSource = block.getParameter("InitialStatesSource");
        if ("Input port".equals(numeratorSource) || "Input port".equals(denominatorSource) || "Input port".equals(initialStateSource)) {
            return "DTF";
        }
        return SimulinkBlockLabelUtils.getNumeratorDenominatorData(block);
    }

    public static String obtainDiscreteIntegratorTextData(SimulinkBlock block) {
        String integratorMethod;
        switch (integratorMethod = block.getParameter("IntegratorMethod")) {
            case "Integration: Forward Euler": {
                return "K Ts\n$FRAC$z-1";
            }
            case "Integration: Backwardd Euler": {
                return "K Ts z\n$FRAC$z-1";
            }
            case "Integration: Trapezoidal": {
                return "K Ts (z+1)\n$FRAC$2(z-1)";
            }
            case "Accumulation: Forward Euler": {
                return "K\n$FRAC$z-1";
            }
            case "Accumulation: Backwardd Euler": {
                return "K z\n$FRAC$z-1";
            }
            case "Accumulation: Trapezoidal": {
                return "K (z+1)\n$FRAC$2(z-1)";
            }
        }
        return "";
    }

    public static String obtainDiscreteZeroPoleTextData(SimulinkBlock block) {
        String polesParameter = block.getParameter("Poles");
        String zerosParameter = block.getParameter("Zeros");
        String[] poles = polesParameter.replaceAll("[\\[\\]]", "").split(" ");
        String[] zeros = zerosParameter.replaceAll("[\\[\\]]", "").split(" ");
        String gainParameter = block.getParameter("Gain");
        if (zeros.length != 1 || poles.length != 2 || !poles[0].equals("0") || !gainParameter.equals("1")) {
            return "zeros(z)\n$FRAC$poles(z)";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        double zero = Double.parseDouble(zeros[0]);
        double pole = Double.parseDouble(poles[1]);
        String formattedZero = decimalFormat.format(zero * -1.0).replace(",", ".");
        String formattedPole = decimalFormat.format(pole * -1.0).replace(",", ".");
        Object formattedLabelText = "(z";
        formattedLabelText = zero < 0.0 ? (String)formattedLabelText + "+" + formattedZero : (String)formattedLabelText + formattedZero;
        formattedLabelText = (String)formattedLabelText + ")\n$FRAC$z(z";
        formattedLabelText = pole < 0.0 ? (String)formattedLabelText + "+" + formattedPole : (String)formattedLabelText + formattedPole;
        return (String)formattedLabelText + ")";
    }

    public static String obtainFunctionCallerBlockData(SimulinkBlock block) {
        return "caller\n" + block.getParameter("FunctionName");
    }

    public static String obtainResetPortBlockIcon(SimulinkBlock block) {
        String triggerType = block.getParameter("ResetTriggerType");
        if ("rising".equals(triggerType)) {
            return "reset_rising_reset_port.png";
        }
        if ("falling".equals(triggerType)) {
            return "reset_falling_reset_port.png";
        }
        if ("either".equals(triggerType)) {
            return "reset_either_reset_port.png";
        }
        return null;
    }

    public static SimulinkBlock hasEventListenerSubBlock(SimulinkBlock block) {
        return block.hasSubBlockOfType("EventListener");
    }

    public static String getEventListenerEventType(SimulinkBlock block) {
        if (!block.isOfType("EventListener")) {
            return null;
        }
        return block.getParameter("EventType");
    }

    private static boolean blockListensToEvent(SimulinkBlock block, String expectedEventType) {
        CCSMAssert.isNotNull((Object)expectedEventType);
        if (!block.isOfType("EventListener")) {
            return false;
        }
        String eventType = block.getParameter("EventType");
        return expectedEventType.equals(eventType);
    }

    public static boolean isResetEventListener(SimulinkBlock block) {
        return SimulinkBlockLabelUtils.blockListensToEvent(block, "Reset");
    }

    public static boolean isTerminateEventListener(SimulinkBlock block) {
        return SimulinkBlockLabelUtils.blockListensToEvent(block, "Terminate");
    }

    public static boolean isInitializeEventListener(SimulinkBlock block) {
        return SimulinkBlockLabelUtils.blockListensToEvent(block, "Initialize");
    }
}

