/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowResolvedIdUtils;

public abstract class StateflowElementBase<P extends IStateflowElement<?>>
extends ParameterizedElement
implements IStateflowElement<P> {
    private P parent;

    protected StateflowElementBase() {
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public String getStateflowId() {
        return this.getParameter("id");
    }

    @Override
    public abstract void remove();

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStateflowId() + "]";
    }

    public void setParent(P parent) {
        if (parent != null) {
            CCSMAssert.isTrue((this.parent == null || this.parent == parent ? 1 : 0) != 0, (String)"Cannot set parent for element that already has a parent");
        }
        this.parent = parent;
    }

    @Override
    public StateflowChart getParentChart() {
        if (this.parent != null) {
            return this.parent.getParentChart();
        }
        return null;
    }

    public SimulinkBlock getSimulinkBlock() {
        String blockName = this.getParameter("simulink.blockName");
        if (blockName == null) {
            return null;
        }
        StateflowBlock parentBlock = this.getParentChart().getStateflowBlock();
        if (parentBlock == null) {
            return null;
        }
        return parentBlock.getSubBlock(blockName);
    }

    @Deprecated
    public String getResolvedId() {
        return new StateflowResolvedIdUtils().getResolvedId(this);
    }
}

