/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model.stateflow;

import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.SimulinkTestExclude;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.datahandler.TransitionLayoutData;
import org.conqat.lib.simulink.model.datahandler.stateflow.StateflowLayoutHandler;
import org.conqat.lib.simulink.model.datahandler.stateflow.TransitionLabelLayoutData;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.util.StateflowUtils;

public class StateflowTransition
extends ParameterizedElement {
    private StateflowNodeBase src;
    private StateflowNodeBase dst;
    private StateflowChart parentChart;

    public StateflowTransition(StateflowNodeBase src, StateflowNodeBase dst) {
        this.src = src;
        this.dst = dst;
        if (src != null) {
            src.addOutTransition(this);
        }
        if (dst != null) {
            dst.addInTransition(this);
        }
    }

    void setParentChart(StateflowChart chart) {
        CCSMAssert.isTrue((this.parentChart == null ? 1 : 0) != 0, (String)"May not set parent chart twice!");
        this.parentChart = chart;
    }

    public String buildQualifiedName() {
        StateflowChart result;
        if (this.dst != null) {
            result = this.dst.getParentChart();
        } else if (this.src != null) {
            result = this.src.getParentChart();
        } else if (this.parentChart != null) {
            result = this.parentChart;
        } else {
            throw new AssertionError((Object)"Expecting at least one way to access the chart!");
        }
        String qualifiedName = result.buildQualifiedName();
        if (this.dst != null) {
            qualifiedName = StateflowTransition.deeperQualifiedName(qualifiedName, this.dst.getParentChart().buildQualifiedName());
        } else if (this.src != null) {
            qualifiedName = StateflowTransition.deeperQualifiedName(qualifiedName, this.src.getParentChart().buildQualifiedName());
        }
        return qualifiedName + "/" + StateflowUtils.extractIdFromStateflowId(this.getId());
    }

    private static String deeperQualifiedName(String qualifiedName1, String qualifiedName2) {
        int depth2;
        int depth1 = StateflowTransition.getQualifiedNameDepth(qualifiedName1);
        if (depth1 > (depth2 = StateflowTransition.getQualifiedNameDepth(qualifiedName2)) || depth1 == depth2 && qualifiedName1.compareTo(qualifiedName2) <= 0) {
            return qualifiedName1;
        }
        return qualifiedName2;
    }

    private static int getQualifiedNameDepth(String qualifiedName1) {
        return StringUtils.countMatches((CharSequence)qualifiedName1, (CharSequence)"/") + StringUtils.countMatches((CharSequence)qualifiedName1, (CharSequence)".");
    }

    public StateflowNodeBase getDst() {
        return this.dst;
    }

    public @Nullable String getLabel() {
        return this.getParameter("labelString");
    }

    public StateflowNodeBase getSrc() {
        return this.src;
    }

    public String getId() {
        return this.getParameter("id");
    }

    public void remove() {
        if (this.src != null) {
            this.src.removeOutTransition(this);
            this.src = null;
        }
        this.dst.removeInTransition(this);
        this.dst = null;
    }

    public String toString() {
        if (this.src == null) {
            return "-> " + String.valueOf(this.dst);
        }
        return String.valueOf(this.src) + " -> " + String.valueOf(this.dst);
    }

    @SimulinkTestExclude
    public TransitionLayoutData obtainLayoutData() {
        return StateflowLayoutHandler.obtainTransitionLayoutData(this);
    }

    public StateflowChart accessChart() {
        if (this.dst != null) {
            return this.dst.getParentChart();
        }
        if (this.src != null) {
            return this.src.getParentChart();
        }
        if (this.parentChart != null) {
            return this.parentChart;
        }
        throw new AssertionError((Object)"Expecting at least one way to access the chart!");
    }

    @SimulinkTestExclude
    public TransitionLabelLayoutData obtainLabelData() {
        return StateflowLayoutHandler.obtainTransitionLabelData(this);
    }
}

