/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.util;

import java.io.PrintStream;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.IStateflowChartContainer;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowElementBase;
import org.conqat.lib.simulink.model.stateflow.StateflowJunction;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.model.stateflow.StateflowTruthTable;
import org.conqat.lib.simulink.util.StateflowChartRenderer;
import org.conqat.lib.simulink.util.StateflowUtils;

public class SimulinkDebugUtils {
    public static String buildReadablePath(SimulinkBlock block) {
        if (block == null) {
            return "";
        }
        if (block.getType().equals("Model")) {
            return ((SimulinkModel)block).getUniformPath() + "(" + block.getParameter("SID") + ")";
        }
        Object path = "";
        while (block != null && !block.getType().equals("Model")) {
            path = ((String)path).isEmpty() ? block.getName() + "(" + block.getParameter("SID") + ")" : block.getName() + "/" + (String)path;
            block = block.getParent();
        }
        return path;
    }

    public static String buildReadablePath(StateflowElementBase<?> node) {
        Object path = "";
        while (node != null && !(node.getParent() instanceof StateflowMachine)) {
            if (node instanceof StateflowChart && ((StateflowChart)node).isSubviewer()) {
                path = "/" + StringUtils.getFirstPart((String)node.getParameter("labelString"), (String)"\\\n") + (String)path;
                node = (StateflowElementBase)((IStateflowChartContainer)((StateflowChart)node).getParent()).getParent();
                continue;
            }
            if (node instanceof StateflowState) {
                String name = StateflowUtils.getStateName((StateflowState)node).trim();
                path = "/" + name + (String)path;
                node = (StateflowElementBase)node.getParent();
                continue;
            }
            if (!(node instanceof StateflowJunction)) continue;
            path = "/junction" + node.getParameter("id");
            node = (StateflowElementBase)node.getParent();
        }
        if (node instanceof StateflowChart && ((StateflowChart)node).getStateflowBlock() != null) {
            String chartName = node.getParameter("name");
            path = SimulinkDebugUtils.buildReadablePath(((StateflowChart)node).getStateflowBlock()) + "/" + chartName + (String)path;
            return path;
        }
        return path;
    }

    public static void printStateflowElement(StateflowElementBase<? extends IStateflowElement<?>> element) {
        SimulinkDebugUtils.printStateflowElement(element, System.out);
    }

    public static void printStateflowElement(StateflowElementBase<? extends IStateflowElement<?>> element, PrintStream out) {
        SimulinkDebugUtils.printStateflowElementRecursive(element, out, 0);
    }

    private static void printStateflowElementRecursive(StateflowElementBase<? extends IStateflowElement<?>> element, PrintStream out, int intendation) {
        String tabs = StringUtils.fillString((int)intendation, (char)'\t');
        out.println(tabs + element.getClass().getSimpleName() + " " + element.getStateflowId() + " " + element.toString());
        if (element instanceof StateflowChart) {
            StateflowChart chart = (StateflowChart)element;
            int unconnectedTransitions = chart.getUnconnectedTransitions().size();
            if (unconnectedTransitions > 0) {
                out.println(unconnectedTransitions + " unconnected transitions in chart");
            }
            for (StateflowNodeBase node : chart.getNodes()) {
                SimulinkDebugUtils.printStateflowElementRecursive(node, out, intendation + 1);
            }
        }
        if (element instanceof StateflowState) {
            SimulinkDebugUtils.printStateflowStateExtraInformation(out, tabs, (StateflowState)element);
        }
        if (element instanceof StateflowNodeBase) {
            SimulinkDebugUtils.printOutgoingTransitions(out, tabs, (StateflowNodeBase)element);
        }
        if (element instanceof StateflowState) {
            SimulinkDebugUtils.printStateflowStateSubNodes(out, tabs, intendation, (StateflowState)element);
        }
    }

    private static void printOutgoingTransitions(PrintStream out, String tabs, StateflowNodeBase element) {
        UnmodifiableSet<StateflowTransition> outTransitions = element.getOutTransitions();
        if (!outTransitions.isEmpty()) {
            out.println(tabs + "|outgoing transitions:");
            for (StateflowTransition transition : outTransitions) {
                out.println(tabs + "\tto " + transition.getDst().getStateflowId() + ": " + transition.getLabel());
            }
        }
    }

    private static void printStateflowStateExtraInformation(PrintStream out, String tabs, StateflowState state) {
        if (state.isSubChart()) {
            StateflowChartRenderer.renderChart(state.getSubViewer());
            out.println(tabs + "This node is a subchart!");
            out.println(tabs + "Parent: " + String.valueOf(state.getParentChart().getParent()));
        }
        if (state instanceof StateflowTruthTable) {
            StateflowTruthTable truthTable = (StateflowTruthTable)state;
            out.println("--------- script ---------");
            out.println(truthTable.getScript());
            out.println("------- end script -------");
        }
    }

    private static void printStateflowStateSubNodes(PrintStream out, String tabs, int intendation, StateflowState state) {
        if (!state.getNodes().isEmpty()) {
            out.println(tabs + "|subnodes:");
            for (StateflowNodeBase node : state.getNodes()) {
                SimulinkDebugUtils.printStateflowElementRecursive(node, out, intendation + 1);
            }
        }
        if (state.isSubChart() && !state.getSubViewer().getNodes().isEmpty()) {
            out.println(tabs + "|subchart nodes:");
            for (StateflowNodeBase node : state.getSubViewer().getNodes()) {
                SimulinkDebugUtils.printStateflowElementRecursive(node, out, intendation + 1);
            }
        }
    }
}

