/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.languages.swift.SwiftShallowParser;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

@Check(id="cqse-avoid-variable-assignment-to-itself", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.CS, ELanguage.JAVASCRIPT, ELanguage.PYTHON, ELanguage.PHP, ELanguage.RUST, ELanguage.KOTLIN, ELanguage.SWIFT, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidVariableAssignmentToItselfCheck
extends CheckImplementationBase {
    public static final String NAME = "Assignment of a variable to itself";
    private static final Map<ELanguage, Set<ETokenType>> SELF_REFERENCE_TOKEN_TYPES_BY_LANGUAGE = CollectionUtils.asMap((Pair[])new Pair[]{Pair.createPair((Object)ELanguage.JAVA, Set.of(ETokenType.THIS)), Pair.createPair((Object)ELanguage.CPP, Set.of(ETokenType.THIS)), Pair.createPair((Object)ELanguage.CPP_MS_CLI, Set.of(ETokenType.THIS)), Pair.createPair((Object)ELanguage.CS, Set.of(ETokenType.THIS)), Pair.createPair((Object)ELanguage.JAVASCRIPT, Set.of(ETokenType.THIS)), Pair.createPair((Object)ELanguage.KOTLIN, Set.of(ETokenType.THIS)), Pair.createPair((Object)ELanguage.PHP, Set.of(ETokenType.THIS)), Pair.createPair((Object)ELanguage.SWIFT, Set.of(ETokenType.SELF)), Pair.createPair((Object)ELanguage.OBJECTIVE_C, Set.of(ETokenType.SELF)), Pair.createPair((Object)ELanguage.OBJECTIVE_CPP, EnumSet.of(ETokenType.SELF, ETokenType.THIS)), Pair.createPair((Object)ELanguage.PYTHON, Set.of(ETokenType.SELF))});
    private static final EnumSet<ETokenType> MEMBER_ACCESS_TOKEN_TYPES = EnumSet.of(ETokenType.DOT, new ETokenType[]{ETokenType.POINTERTO, ETokenType.ARROW, ETokenType.DOUBLE_COLON, ETokenType.SAFECALL_OPERATOR, ETokenType.SCOPE});
    private static final EnumSet<ETokenType> SWIFT_NULL_CHECK_TOKEN_TYPES = EnumSet.of(ETokenType.IF, ETokenType.GUARD);
    private static final EnumSet<ETokenType> SWIFT_VARIABLE_DEFINE_TOKEN_TYPES = EnumSet.of(ETokenType.LET, ETokenType.VAR);
    private static final EnumSet<ETokenType> TYPESCRIPT_VARIABLE_DEFINE_TOKEN_TYPES = EnumSet.of(ETokenType.LET, ETokenType.VAR, ETokenType.CONST);
    private static final EnumSet<ETokenType> JAVASCRIPT_LEFT_HAND_SIDE_START_TOKEN_TYPES = EnumSet.of(ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.COMMA);
    private static final EnumSet<ETokenType> JAVASCRIPT_RIGHT_HAND_SIDE_END_TOKEN_TYPES = EnumSet.of(ETokenType.SEMICOLON, ETokenType.COMMA, ETokenType.RBRACK, ETokenType.RBRACE);
    private static final EnumSet<ETokenType> JAVASCRIPT_ORDER_INSENSITIVE_START_TOKEN_TYPES = EnumSet.of(ETokenType.LBRACE, ETokenType.COMMA);
    private static final EnumSet<ETokenType> JAVASCRIPT_ORDER_INSENSITIVE_END_TOKEN_TYPES = EnumSet.of(ETokenType.COMMA, ETokenType.RBRACE);
    private static final int NAME_GROUP_INDEX = 0;
    private static final int VARIABLE_GROUP_INDEX = 1;
    private static final ITokenMatcher DEFAULT_END_OF_ANALYZE_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOL, ETokenType.COMMA, ETokenType.RPAREN, ETokenType.RBRACE});
    private static final ITokenMatcher PYTHON_END_OF_ANALYZE_TOKEN_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.EOL, ETokenType.RPAREN});
    private static final int OBJECT_INITIALIZER_OPENING_BRACKET_INDEX = 0;
    private static final TokenPattern JAVASCRIPT_ORDER_INSENSITIVE_LEFT_HAND_SIDE_NAME_PATTERN = new TokenPattern().repeatedAtLeastOnce(new Object[]{new TokenPattern().sequence(new Object[]{JAVASCRIPT_ORDER_INSENSITIVE_START_TOKEN_TYPES}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).skipTo(new Object[]{JAVASCRIPT_ORDER_INSENSITIVE_END_TOKEN_TYPES})});
    private static final TokenPattern JAVASCRIPT_ORDER_INSENSITIVE_LEFT_HAND_SIDE_VARIABLE_PATTERN = new TokenPattern().repeatedAtLeastOnce(new Object[]{new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{JAVASCRIPT_ORDER_INSENSITIVE_START_TOKEN_TYPES}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).notFollowedBy((Object)ETokenType.COLON), new TokenPattern().sequence(new Object[]{ETokenType.COLON}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1)}).skipTo(new Object[]{JAVASCRIPT_ORDER_INSENSITIVE_END_TOKEN_TYPES})});
    private static final TokenPattern JAVASCRIPT_ORDER_INSENSITIVE_RIGHT_HAND_SIDE_PATTERN = new TokenPattern().repeatedAtLeastOnce(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.COLON}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).notFollowedBy(EnumSet.of(ETokenType.DOT, ETokenType.LBRACK))});
    private static final TokenPattern CSHARP_OBJECT_INITIALIZER_TEMPLATE = new TokenPattern().sequence(new Object[]{ETokenType.NEW}).skipTo(new Object[]{ETokenType.LBRACE}).group(0);

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (this.shouldSkipEntity(entity)) {
            return;
        }
        List<IToken> tokens = entity.ownTokens().stream().flatMap(Collection::stream).toList();
        List equalSignTokenIndices = TokenStreamUtils.findAll(tokens, (int)1, (int)tokens.size(), (ITokenMatcher)ETokenType.EQ);
        Iterator iterator = equalSignTokenIndices.iterator();
        while (iterator.hasNext()) {
            List<IToken> rightHandSide;
            int equalSignTokenIndex = (Integer)iterator.next();
            List<IToken> leftHandSide = this.getLeftHandSideTokens(tokens, equalSignTokenIndex);
            if (this.areMultipleAssignmentsPossible(leftHandSide, rightHandSide = this.getRightHandSideTokens(tokens, equalSignTokenIndex))) {
                this.analyzeMultipleAssignments(leftHandSide, rightHandSide, tokens, equalSignTokenIndex);
                continue;
            }
            this.analyzeAssignment(leftHandSide, rightHandSide, tokens, equalSignTokenIndex);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private boolean shouldSkipEntity(ShallowEntity entity) {
        return switch (this.context.getLanguage()) {
            case ELanguage.SWIFT -> AvoidVariableAssignmentToItselfCheck.isLocalVariableDeclaration(entity, ETokenType.VAR);
            case ELanguage.KOTLIN -> AvoidVariableAssignmentToItselfCheck.isLocalVariableDeclaration(entity, ETokenType.VAL);
            default -> false;
        };
    }

    private static boolean isLocalVariableDeclaration(ShallowEntity entity, ETokenType variableDeclarationToken) {
        return entity.getType() == EShallowEntityType.STATEMENT && "local variable".equals(entity.getSubtype()) && ((IToken)entity.ownStartTokens().getFirst()).getType() == variableDeclarationToken;
    }

    private boolean areMultipleAssignmentsPossible(List<IToken> leftHandSide, List<IToken> rightHandSide) {
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return AvoidVariableAssignmentToItselfCheck.hasJavascriptDataStructure(leftHandSide) && AvoidVariableAssignmentToItselfCheck.hasJavascriptDataStructure(rightHandSide);
        }
        return false;
    }

    private static boolean hasJavascriptDataStructure(List<IToken> tokens) {
        return !tokens.isEmpty() && JAVASCRIPT_LEFT_HAND_SIDE_START_TOKEN_TYPES.contains(tokens.getFirst().getType());
    }

    private void analyzeMultipleAssignments(List<IToken> leftHandSide, List<IToken> rightHandSide, List<IToken> tokens, int equalSignTokenIndex) {
        boolean isOrderSensitive = this.isOrderSensitive(leftHandSide);
        Map<String, List<IToken>> leftHandSideDataStructure = this.extractMapOfDataStructureFromLeftHandSide(leftHandSide, isOrderSensitive);
        Map<String, List<IToken>> rightHandSideDataStructure = this.extractMapOfDataStructureFromRightHandSide(rightHandSide, isOrderSensitive);
        for (Map.Entry<String, List<IToken>> entry : leftHandSideDataStructure.entrySet()) {
            String name = entry.getKey();
            if (!rightHandSideDataStructure.containsKey(name)) continue;
            this.analyzeAssignment(entry.getValue(), rightHandSideDataStructure.get(name), tokens, equalSignTokenIndex);
        }
    }

    private Map<String, List<IToken>> extractMapOfDataStructureFromLeftHandSide(List<IToken> leftHandSide, boolean isOrderSensitive) {
        if (isOrderSensitive) {
            return this.extractMapOfOrderSensitiveDataStructure(leftHandSide);
        }
        return this.extractMapOfOrderInsensitiveDataStructureFromLeftHandSide(leftHandSide);
    }

    private Map<String, List<IToken>> extractMapOfDataStructureFromRightHandSide(List<IToken> rightHandSide, boolean isOrderSensitive) {
        if (isOrderSensitive) {
            return this.extractMapOfOrderSensitiveDataStructure(rightHandSide);
        }
        return this.extractMapOfOrderInsensitiveDataStructureFromRightHandSide(rightHandSide);
    }

    private Map<String, List<IToken>> extractMapOfOrderSensitiveDataStructure(List<IToken> tokens) {
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return AvoidVariableAssignmentToItselfCheck.extractMapOfOrderSensitiveJavascriptDataStructure(tokens);
        }
        return CollectionUtils.emptyMap();
    }

    private Map<String, List<IToken>> extractMapOfOrderInsensitiveDataStructureFromLeftHandSide(List<IToken> leftHandSide) {
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return AvoidVariableAssignmentToItselfCheck.extractMapOfOrderInsensitiveJavascriptDataStructureFromLeftHandSide(leftHandSide);
        }
        return CollectionUtils.emptyMap();
    }

    private Map<String, List<IToken>> extractMapOfOrderInsensitiveDataStructureFromRightHandSide(List<IToken> rightHandSide) {
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return AvoidVariableAssignmentToItselfCheck.extractMapOfOrderInsensitiveJavascriptDataStructureFromRightHandSide(rightHandSide);
        }
        return CollectionUtils.emptyMap();
    }

    private static Map<String, List<IToken>> extractMapOfOrderSensitiveJavascriptDataStructure(List<IToken> tokens) {
        List endIndices = TokenStreamUtils.getTopLevelCommaIndices(tokens, (int)1, (int)(tokens.size() - 1), Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK));
        endIndices.add(tokens.size() - 1);
        HashMap<String, List<IToken>> orderSensitiveDataStructure = new HashMap<String, List<IToken>>();
        int startIndex = 1;
        Iterator iterator = endIndices.iterator();
        while (iterator.hasNext()) {
            int endIndex = (Integer)iterator.next();
            int nextStart = endIndex + 1;
            for (int i = startIndex; i < endIndex; ++i) {
                if (tokens.get(i).getType() != ETokenType.EQ) continue;
                endIndex = i;
                break;
            }
            orderSensitiveDataStructure.put(String.valueOf(orderSensitiveDataStructure.size()), tokens.subList(startIndex, endIndex));
            startIndex = nextStart;
        }
        return orderSensitiveDataStructure;
    }

    private static Map<String, List<IToken>> extractMapOfOrderInsensitiveJavascriptDataStructureFromLeftHandSide(List<IToken> leftHandSide) {
        List names = AvoidVariableAssignmentToItselfCheck.extractMatchedObjectsFromTokens(leftHandSide, JAVASCRIPT_ORDER_INSENSITIVE_LEFT_HAND_SIDE_NAME_PATTERN, 0).stream().map(TokenStreamTextUtils::concatTokenTexts).collect(Collectors.toList());
        List<List<IToken>> variables = AvoidVariableAssignmentToItselfCheck.extractMatchedObjectsFromTokens(leftHandSide, JAVASCRIPT_ORDER_INSENSITIVE_LEFT_HAND_SIDE_VARIABLE_PATTERN, 1);
        if (names.size() != variables.size()) {
            return Collections.emptyMap();
        }
        return CollectionUtils.zipAsMap(names, variables);
    }

    private static Map<String, List<IToken>> extractMapOfOrderInsensitiveJavascriptDataStructureFromRightHandSide(List<IToken> rightHandSide) {
        HashMap<String, List<IToken>> orderInsensitiveDataStructure = new HashMap<String, List<IToken>>();
        List matches = JAVASCRIPT_ORDER_INSENSITIVE_RIGHT_HAND_SIDE_PATTERN.findAll(rightHandSide);
        for (TokenPatternMatch match : matches) {
            orderInsensitiveDataStructure.put(TokenStreamTextUtils.concatTokenTexts((List)match.groupTokens(0)), match.groupTokens(1));
        }
        return orderInsensitiveDataStructure;
    }

    private boolean isOrderSensitive(List<IToken> tokens) {
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return AvoidVariableAssignmentToItselfCheck.isOrderSensitiveForJavascript(tokens);
        }
        return false;
    }

    private static boolean isOrderSensitiveForJavascript(List<IToken> tokens) {
        for (IToken token : tokens) {
            ETokenType currentType = token.getType();
            if (currentType == ETokenType.LBRACK) {
                return true;
            }
            if (currentType != ETokenType.LBRACE) continue;
            return false;
        }
        return false;
    }

    private static List<List<IToken>> extractMatchedObjectsFromTokens(List<IToken> tokens, TokenPattern pattern, int groupIndex) {
        List patternMatches = pattern.findAll(tokens);
        ArrayList<List<IToken>> objects = new ArrayList<List<IToken>>();
        for (TokenPatternMatch match : patternMatches) {
            List matchedToken = match.groupTokens(groupIndex);
            objects.add(matchedToken);
        }
        return objects;
    }

    private List<IToken> getLeftHandSideTokens(List<IToken> tokens, int equalSignTokenIndex) {
        List<IToken> leftHandSide = tokens.subList(0, equalSignTokenIndex);
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return AvoidVariableAssignmentToItselfCheck.extractValidLeftHandSideForJavascript(leftHandSide);
        }
        boolean isIdentifierExpected = true;
        int startIndex = 0;
        for (int i = leftHandSide.size() - 1; i >= 0; --i) {
            boolean isReachedStartOfExpression;
            ETokenType currentTokenType = leftHandSide.get(i).getType();
            if (isIdentifierExpected) {
                isReachedStartOfExpression = !this.isReferenceTokenType(currentTokenType);
            } else {
                boolean bl = isReachedStartOfExpression = !MEMBER_ACCESS_TOKEN_TYPES.contains(currentTokenType);
            }
            if (isReachedStartOfExpression) {
                startIndex = i + 1;
                break;
            }
            isIdentifierExpected = !isIdentifierExpected;
        }
        return tokens.subList(startIndex, equalSignTokenIndex);
    }

    private static List<IToken> extractValidLeftHandSideForJavascript(List<IToken> uncheckedLeftHandSide) {
        ETokenType lastTokenType;
        int startIndex = TokenStreamUtils.findMatchingOpeningToken(uncheckedLeftHandSide, (int)(uncheckedLeftHandSide.size() - 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN) + 1;
        int endIndex = uncheckedLeftHandSide.size();
        if (uncheckedLeftHandSide.size() > startIndex && TYPESCRIPT_VARIABLE_DEFINE_TOKEN_TYPES.contains(uncheckedLeftHandSide.get(startIndex).getType())) {
            ++startIndex;
        }
        if ((lastTokenType = uncheckedLeftHandSide.get(endIndex - 1).getType()) != ETokenType.RBRACE && lastTokenType != ETokenType.RBRACK) {
            boolean isColonExpected = false;
            boolean isNewStartExpected = true;
            for (int i = startIndex; i < uncheckedLeftHandSide.size(); ++i) {
                ETokenType currentTokenType = uncheckedLeftHandSide.get(i).getType();
                boolean bl = isColonExpected = isColonExpected || currentTokenType == ETokenType.LBRACE;
                if (currentTokenType == ETokenType.COLON && !isColonExpected) {
                    endIndex = i;
                    break;
                }
                if (isNewStartExpected) {
                    startIndex = i;
                }
                isNewStartExpected = currentTokenType == ETokenType.COLON || JAVASCRIPT_LEFT_HAND_SIDE_START_TOKEN_TYPES.contains(currentTokenType);
            }
        }
        return uncheckedLeftHandSide.subList(startIndex, endIndex);
    }

    private boolean isReferenceTokenType(ETokenType currentTokenType) {
        return currentTokenType == ETokenType.IDENTIFIER || SELF_REFERENCE_TOKEN_TYPES_BY_LANGUAGE.getOrDefault(this.context.getLanguage(), Collections.emptySet()).contains(currentTokenType);
    }

    private List<IToken> getRightHandSideTokens(List<IToken> tokens, int equalsSignTokenIndex) {
        List<IToken> rightHandSide = tokens.subList(equalsSignTokenIndex + 1, tokens.size());
        if (this.context.getLanguage() == ELanguage.JAVASCRIPT) {
            return AvoidVariableAssignmentToItselfCheck.extractValidRightHandSideForJavascript(rightHandSide);
        }
        if (this.context.getLanguage() == ELanguage.SWIFT) {
            return AvoidVariableAssignmentToItselfCheck.extractValidRightHandSideForSwift(rightHandSide);
        }
        int endIndex = TokenStreamUtils.firstTokenMatching(rightHandSide, (ITokenMatcher)AvoidVariableAssignmentToItselfCheck.endOfAnalyzeToken(this.context.getLanguage()));
        if (endIndex == -1) {
            endIndex = rightHandSide.size();
        }
        return rightHandSide.subList(0, endIndex);
    }

    private static List<IToken> extractValidRightHandSideForJavascript(List<IToken> uncheckedRightHandSide) {
        int endIndex = uncheckedRightHandSide.size() - 1;
        if (endIndex < 0) {
            return uncheckedRightHandSide;
        }
        int validSize = TokenStreamUtils.findMatchingClosingToken(uncheckedRightHandSide, (int)0, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (validSize == -1) {
            validSize = endIndex;
        }
        for (int i = 0; i < validSize; ++i) {
            ETokenType currentType = uncheckedRightHandSide.get(i).getType();
            if (currentType == ETokenType.LBRACK || currentType == ETokenType.LBRACE) {
                endIndex = validSize;
                break;
            }
            if (!JAVASCRIPT_RIGHT_HAND_SIDE_END_TOKEN_TYPES.contains(currentType)) continue;
            endIndex = i;
            break;
        }
        return uncheckedRightHandSide.subList(0, endIndex);
    }

    private static List<IToken> extractValidRightHandSideForSwift(List<IToken> rightHandSide) {
        int endIndex = TokenStreamUtils.firstTokenOfTypeNotFollowedBy(rightHandSide, (int)0, (int)rightHandSide.size(), (ITokenMatcher)DEFAULT_END_OF_ANALYZE_TOKEN_TYPES, (ITokenMatcher)SwiftShallowParser.CONTINUES_SIMPLE_STATEMENTS);
        if (endIndex == -1) {
            endIndex = rightHandSide.size();
        }
        return rightHandSide.subList(0, endIndex).stream().filter(token -> token.getType() != ETokenType.EOL).collect(Collectors.toList());
    }

    private void analyzeAssignment(List<IToken> leftHandSide, List<IToken> rightHandSide, List<IToken> tokens, int equalSignTokenIndex) {
        if (!AvoidVariableAssignmentToItselfCheck.areLeftAndRightTokensSame(leftHandSide, rightHandSide) || this.ignoreAssignmentWithRightHandSide(rightHandSide.subList(leftHandSide.size(), rightHandSide.size()))) {
            return;
        }
        if (this.hasExcludedCases(tokens, equalSignTokenIndex)) {
            return;
        }
        String variableName = TokenStreamTextUtils.concatTokenTexts(leftHandSide);
        this.buildFinding("`" + variableName + "` is assigned to itself", this.buildLocation().betweenTokens(leftHandSide.getFirst(), leftHandSide.getLast())).createAndStore();
    }

    private boolean hasExcludedCases(List<IToken> tokens, int equalSignTokenIndex) {
        return this.isOptionalArgumentAssignmentInsideFunctionCall(tokens, equalSignTokenIndex) || this.hasNullCheckInSwift(tokens) || this.isCSharpObjectInitializer(tokens, equalSignTokenIndex);
    }

    private boolean hasNullCheckInSwift(List<IToken> tokens) {
        if (this.context.getLanguage() != ELanguage.SWIFT) {
            return false;
        }
        if (SWIFT_NULL_CHECK_TOKEN_TYPES.contains(tokens.getFirst().getType()) || TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.ELSE, ETokenType.IF})) {
            for (IToken token : tokens) {
                if (SWIFT_VARIABLE_DEFINE_TOKEN_TYPES.contains(token.getType())) {
                    return true;
                }
                if (token.getType() != ETokenType.LBRACE) continue;
                break;
            }
        }
        return false;
    }

    private static boolean areLeftAndRightTokensSame(List<IToken> leftHandSide, List<IToken> rightHandSide) {
        if (leftHandSide.isEmpty() || rightHandSide.size() < leftHandSide.size()) {
            return false;
        }
        for (int i = 0; i < leftHandSide.size(); ++i) {
            IToken leftToken = leftHandSide.get(i);
            IToken rightToken = rightHandSide.get(i);
            if (leftToken.getText().equals(rightToken.getText())) continue;
            return false;
        }
        return true;
    }

    private boolean ignoreAssignmentWithRightHandSide(List<IToken> remainingTokens) {
        return !remainingTokens.stream().map(IToken::getType).allMatch(type -> type == ETokenType.PLUSPLUS || this.context.getLanguage() == ELanguage.KOTLIN && type == ETokenType.DOUBLE_EXCLAMATION);
    }

    private boolean isOptionalArgumentAssignmentInsideFunctionCall(List<IToken> tokens, int equalSignTokenIndex) {
        if (this.context.getLanguage() != ELanguage.PYTHON && this.context.getLanguage() != ELanguage.KOTLIN) {
            return false;
        }
        int beforeEqualSignIndex = equalSignTokenIndex - 2;
        int afterEqualSignIndex = equalSignTokenIndex + 2;
        if (beforeEqualSignIndex <= 0 || tokens.size() <= afterEqualSignIndex) {
            return false;
        }
        int leftParenthesisIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, (int)beforeEqualSignIndex, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        int rightParenthesisIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)equalSignTokenIndex, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (leftParenthesisIndex == -1 || rightParenthesisIndex == -1) {
            return false;
        }
        return leftParenthesisIndex < equalSignTokenIndex && equalSignTokenIndex < rightParenthesisIndex;
    }

    private boolean isCSharpObjectInitializer(List<IToken> tokens, int equalSignTokenIndex) {
        if (this.context.getLanguage() != ELanguage.CS) {
            return false;
        }
        TokenPatternMatch match = CSHARP_OBJECT_INITIALIZER_TEMPLATE.findFirstMatch(tokens);
        if (AvoidVariableAssignmentToItselfCheck.isNullOrEmptyMatch(match, 0)) {
            return false;
        }
        int openingLeftBracketIndex = AvoidVariableAssignmentToItselfCheck.findTokenIndex(match, tokens, 0);
        int closingRightBracketIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(openingLeftBracketIndex + 1), (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE);
        return openingLeftBracketIndex < equalSignTokenIndex && equalSignTokenIndex < closingRightBracketIndex;
    }

    private static int findTokenIndex(TokenPatternMatch match, List<IToken> tokens, int groupIndex) {
        int tokenOffset = ((IToken)match.groupTokens(groupIndex).getFirst()).getOffset();
        Optional<IToken> matchedToken = tokens.stream().filter(token -> token.getOffset() == tokenOffset).findFirst();
        return matchedToken.map(tokens::indexOf).orElse(-1);
    }

    private static boolean isNullOrEmptyMatch(TokenPatternMatch match, int groupIndex) {
        return match == null || !match.hasGroup(groupIndex) || match.getMatchGroup(groupIndex).isEmpty() || ((MatchGroupElement)match.getMatchGroup(groupIndex).getFirst()).getTokens().isEmpty();
    }

    private static ITokenMatcher endOfAnalyzeToken(ELanguage language) {
        if (language == ELanguage.PYTHON) {
            return PYTHON_END_OF_ANALYZE_TOKEN_TYPES;
        }
        return DEFAULT_END_OF_ANALYZE_TOKEN_TYPES;
    }
}

