/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.cs.CsCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-dont-hide-exception-stack-trace", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DontHideExceptionStackTraceCheck
extends CheckImplementationBase {
    private static final String STACK_TRACE = "StackTrace";
    private static final String GET_STACK_TRACE = "getStackTrace";
    private static final String EXCEPTION_UTILS = "ExceptionUtils";
    private static final String DOT = ".";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String FINDING_MESSAGE = "Exception stacktrace is lost";
    private static final TokenPattern EXCEPTION_VARIABLE_NAME_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{ETokenType.IDENTIFIER}).group(2).sequence(new Object[]{ETokenType.RPAREN, ETokenType.LBRACE});
    private static final TokenPattern VARIABLE_AS_CONSTRUCTOR_ARGUMENT_PATTERN = new TokenPattern().sequence(new Object[]{EnumSet.of(ETokenType.LPAREN, ETokenType.COMMA)}).optional(new Object[]{ETokenType.IDENTIFIER, ETokenType.COLON}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{EnumSet.of(ETokenType.RPAREN, ETokenType.COMMA)});
    @CheckOption(name="Exception stacktrace is lost: Ignored exception types", description="A list of exception types for which not to check whether the stacktrace is passed on.")
    private Set<String> ignoredExceptionTypes = CollectionUtils.asHashSet((Object[])new String[]{"NumberFormatException"});

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"catch".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (this.context.getLanguage() == ELanguage.CS && DontHideExceptionStackTraceCheck.isAnonymousCsCatchBlock(entity)) {
            DontHideExceptionStackTraceCheck.checkThrows(entity, this::checkThrowsStatementInAnonymousCsCatchBlock);
            return;
        }
        TokenPatternMatch exceptionVariableMatch = EXCEPTION_VARIABLE_NAME_PATTERN.findFirstMatch((List)entity.ownStartTokens());
        if (exceptionVariableMatch == null) {
            return;
        }
        if (this.ignoredExceptionTypes.contains(exceptionVariableMatch.groupString(1))) {
            return;
        }
        String exceptionVariableName = exceptionVariableMatch.groupString(2);
        DontHideExceptionStackTraceCheck.checkThrows(entity, throwEntity -> this.checkThrowsStatement(exceptionVariableName, throwEntity));
    }

    private static boolean isAnonymousCsCatchBlock(ShallowEntity entity) {
        return TokenStreamUtils.hasTypes((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.LBRACE}) || TokenStreamUtils.hasTypes((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.CATCH, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.LBRACE});
    }

    private static void checkThrows(ShallowEntity catchEntity, ThrowEntityChecker checkFunction) throws CheckException {
        for (ShallowEntity throwEntity : DontHideExceptionStackTraceCheck.select((ShallowEntity)catchEntity, (String)".//STATEMENT[subtype('simple statement') and name-matches('throw')]")) {
            if (!DontHideExceptionStackTraceCheck.belongsToCatch(throwEntity, catchEntity)) continue;
            checkFunction.check(throwEntity);
        }
    }

    private static boolean belongsToCatch(ShallowEntity entity, ShallowEntity catchEntity) {
        Optional parentCatchEntityOptional = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)entity, e -> e.getSubtype().equals("catch"));
        return parentCatchEntityOptional.map(parentCatchEntity -> parentCatchEntity.equals(catchEntity)).orElse(false);
    }

    private void checkThrowsStatementInAnonymousCsCatchBlock(ShallowEntity throwEntity) {
        if (!TokenStreamUtils.hasTypes((List)throwEntity.includedTokens(), (ETokenType[])new ETokenType[]{ETokenType.THROW, ETokenType.SEMICOLON})) {
            this.createFinding(throwEntity);
        }
    }

    private void checkThrowsStatement(String exceptionVariableName, ShallowEntity throwEntity) {
        if (!TokenStreamUtils.containsAny((List)throwEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.NEW})) {
            return;
        }
        if (this.context.getLanguage() == ELanguage.CS && DontHideExceptionStackTraceCheck.containsStacktraceCallInStringInterpolation(throwEntity, exceptionVariableName)) {
            return;
        }
        List matches = VARIABLE_AS_CONSTRUCTOR_ARGUMENT_PATTERN.findAll((List)throwEntity.includedTokens());
        for (TokenPatternMatch match : matches) {
            if (!match.groupString(1).equals(exceptionVariableName)) continue;
            return;
        }
        ELanguage fileLanguage = this.context.getLanguage();
        UnmodifiableList siblings = throwEntity.getParent().getChildren();
        for (ShallowEntity sibling : siblings) {
            if ((fileLanguage != ELanguage.CS || !DontHideExceptionStackTraceCheck.entityContainsSequence(sibling, exceptionVariableName, DOT, STACK_TRACE)) && (fileLanguage != ELanguage.JAVA || !DontHideExceptionStackTraceCheck.entityContainsJavaGetStackTraceSequence(sibling, exceptionVariableName))) continue;
            return;
        }
        this.createFinding(throwEntity);
    }

    private static boolean containsStacktraceCallInStringInterpolation(ShallowEntity entity, String exceptionVariableName) {
        return !CsCheckUtils.checkForVariableUseInStringInterpolation((List)entity.includedTokens(), (String)(exceptionVariableName + ".StackTrace")).isEmpty();
    }

    private static boolean entityContainsSequence(ShallowEntity entity, String ... sequence) {
        return TokenStreamTextUtils.findSequence((List)entity.includedTokens(), (int)0, (ETokenType)ETokenType.IDENTIFIER, (String[])sequence) != -1;
    }

    private static boolean entityContainsJavaGetStackTraceSequence(ShallowEntity entity, String exceptionVariableName) {
        return DontHideExceptionStackTraceCheck.entityContainsSequence(entity, exceptionVariableName, DOT, GET_STACK_TRACE) || DontHideExceptionStackTraceCheck.entityContainsSequence(entity, EXCEPTION_UTILS, DOT, GET_STACK_TRACE, LEFT_PARENTHESIS, exceptionVariableName, RIGHT_PARENTHESIS);
    }

    private void createFinding(ShallowEntity throwEntity) {
        this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntityFirstLine(throwEntity, ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
    }

    @FunctionalInterface
    private static interface ThrowEntityChecker {
        public void check(ShallowEntity var1) throws CheckException;
    }
}

