/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.util.cpp.BinarySizeCheckUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Check(id="cqse-machine-size-compliance", languages={ELanguage.C, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MachineSizeComplianceCheck
extends CheckImplementationBase {
    @CheckOption(name="Compliant size in bits", description="The default machine size in bits. Any data type larger than this size will trigger a finding")
    private int defaultSize = 32;
    private static final String MESSAGE = "Using %s on %d-bit machine";
    private static final Set<ETokenType> DATA_TYPE_PREFIX_TOKENS = EnumSet.of(ETokenType.UNSIGNED, ETokenType.SIGNED, ETokenType.LONG, ETokenType.SHORT);

    public void execute() throws CheckException {
        List tokens = this.context.getTokens(ECodeViewOption.FILTERED);
        this.processTokens(tokens);
    }

    private void processTokens(List<IToken> tokens) {
        block0: for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
            if (DATA_TYPE_PREFIX_TOKENS.contains(tokens.get(tokenIndex).getType())) {
                for (int tokenLength = 4; tokenLength >= 1; --tokenLength) {
                    List<IToken> possibleTypeTokens;
                    String possibleType;
                    if (tokenIndex + tokenLength > tokens.size() || !BinarySizeCheckUtils.isSupportedType((String)(possibleType = TokenStreamTextUtils.concatTokenTexts(possibleTypeTokens = tokens.subList(tokenIndex, tokenIndex + tokenLength), (String)" ")))) continue;
                    this.checkTypeForFinding(possibleType, tokens.get(tokenIndex));
                    tokenIndex += tokenLength - 1;
                    continue block0;
                }
                continue;
            }
            this.checkTypeForFinding(tokens.get(tokenIndex).getText(), tokens.get(tokenIndex));
        }
    }

    private void checkTypeForFinding(String type, IToken token) {
        if (!BinarySizeCheckUtils.isSupportedType((String)type)) {
            return;
        }
        if (type.contains("*")) {
            return;
        }
        int architectureWordSizeInBytes = this.defaultSize / 8;
        Optional optionalEntityTypeSize = BinarySizeCheckUtils.determineSizeOfType((String)type, (int)architectureWordSizeInBytes);
        if (optionalEntityTypeSize.isEmpty()) {
            return;
        }
        int entitySize = (Integer)optionalEntityTypeSize.get() * 8;
        if (entitySize > this.defaultSize) {
            this.buildFinding(MESSAGE.formatted(type, this.defaultSize), this.buildLocation().forToken(token)).createAndStore();
        }
    }
}

