/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.cpp.CppSuperclassHierarchyExtractorPhase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

@Check(id="cqse-virtual-destructor", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={CppSuperclassHierarchyExtractorPhase.class})
public class VirtualDestructorCheck
extends CheckImplementationBase {
    @CheckOption(name="Include final classes", description="Reports final classes that have no virtual destructor as finding.")
    private boolean includeFinalClasses = false;
    @CheckOption(name="Include structs", description="Reports structs that have no virtual destructor as finding.")
    private boolean includeStructs = false;
    private static final Set<String> DESTRUCTOR_SUBTYPES = Set.of("destructor declaration", "destructor");

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (PreprocessorUtils.isEntityMacroExpanded((ShallowEntity)type)) continue;
            if ("class".equals(type.getSubtype())) {
                if (!this.includeFinalClasses && TokenStreamUtils.contains((List)type.ownStartTokens(), (ETokenType)ETokenType.FINAL)) continue;
                this.processEntity(type);
                continue;
            }
            if (!this.includeStructs || !"struct".equals(type.getSubtype())) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        boolean superclassDeclaresVirtualDestructor;
        ShallowEntity destructor = VirtualDestructorCheck.getDestructor(entity);
        String className = entity.getName();
        boolean hasVirtualMethods = VirtualDestructorCheck.hasVirtualMethods(entity);
        boolean hasSubclass = VirtualDestructorCheck.hasSubclass(this.context, className);
        boolean isStruct = this.includeStructs && TokenStreamUtils.containsAny((List)entity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.STRUCT});
        boolean hasValidDestructor = VirtualDestructorCheck.hasValidDestructor(entity, destructor, isStruct);
        CppSuperclassHierarchyExtractorPhase.SuperclassHierarchyValue parentHierarchy = VirtualDestructorCheck.getParentHierarchy(this.context, className).orElse(null);
        boolean bl = superclassDeclaresVirtualDestructor = parentHierarchy != null && this.declaresVirtualDestructorInAnySuperclass(parentHierarchy);
        if (!hasSubclass && !hasVirtualMethods || VirtualDestructorCheck.destructorIsDefinedAsDelete(destructor) || VirtualDestructorCheck.isConstructorDefinedAsDelete(entity) || superclassDeclaresVirtualDestructor || hasValidDestructor) {
            return;
        }
        this.buildFinding("Class " + entity.getName() + " should have a virtual destructor.", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
    }

    private static boolean isConstructorDefinedAsDelete(ShallowEntity typeEntity) {
        for (ShallowEntity child : typeEntity.getChildren()) {
            if (child.getType() != EShallowEntityType.METHOD || !child.getSubtype().equals("constructor") && !child.getSubtype().equals("constructor declaration") || !TokenStreamUtils.endsWith((List)child.includedTokens(), (ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.DELETE, ETokenType.SEMICOLON})) continue;
            return true;
        }
        return false;
    }

    private static boolean destructorIsDefinedAsDelete(ShallowEntity destructorEntity) {
        if (destructorEntity == null) {
            return false;
        }
        return TokenStreamUtils.endsWith((List)destructorEntity.includedTokens(), (ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.DELETE, ETokenType.SEMICOLON});
    }

    private boolean declaresVirtualDestructorInAnySuperclass(CppSuperclassHierarchyExtractorPhase.SuperclassHierarchyValue superclassHierarchy) {
        CppSuperclassHierarchyExtractorPhase.SuperClassAndVirtualDestructorInfo superClassAndVirtualDestructorInfo = superclassHierarchy.getAdditionalInformation();
        if (superClassAndVirtualDestructorInfo.hasVirtualDestructor()) {
            return true;
        }
        HashSet<String> seenParentClasses = new HashSet<String>();
        ArrayDeque<String> workQueue = new ArrayDeque<String>();
        workQueue.addAll(superclassHierarchy.getAdditionalInformation().getSuperClasses());
        while (!workQueue.isEmpty()) {
            String current = (String)workQueue.pop();
            List phaseResult = (List)this.context.accessPhaseInvertedResult(CppSuperclassHierarchyExtractorPhase.class).apply(current);
            if (phaseResult == null) continue;
            HashSet<String> potentialSuperclasses = new HashSet<String>();
            for (CppSuperclassHierarchyExtractorPhase.SuperclassHierarchyValue inheritanceRelation : phaseResult) {
                if (inheritanceRelation.getAdditionalInformation().hasVirtualDestructor()) {
                    return true;
                }
                potentialSuperclasses.addAll(inheritanceRelation.getAdditionalInformation().getSuperClasses());
            }
            for (String potentialSuperclass : potentialSuperclasses) {
                if (seenParentClasses.contains(potentialSuperclass)) continue;
                seenParentClasses.add(potentialSuperclass);
                workQueue.add(potentialSuperclass);
            }
        }
        return false;
    }

    private static ShallowEntity getDestructor(ShallowEntity entity) {
        List methods = entity.getChildrenOfType(EShallowEntityType.METHOD);
        return methods.stream().filter(x -> DESTRUCTOR_SUBTYPES.contains(x.getSubtype())).findFirst().orElse(null);
    }

    private static boolean hasValidDestructor(ShallowEntity classEntity, ShallowEntity destructor, boolean isStruct) {
        if (destructor == null) {
            return false;
        }
        return LanguageFeatureParser.CPP.isVirtual(destructor) || LanguageFeatureParser.CPP.getVisibility(classEntity, destructor, isStruct).equals("public") || VirtualDestructorCheck.isOverride(destructor);
    }

    private static boolean hasSubclass(ICheckContext context, String className) {
        return ((List)context.accessPhaseInvertedResult(CppSuperclassHierarchyExtractorPhase.class).apply(className)).stream().anyMatch(x -> x.getAdditionalInformation().hasSubClass());
    }

    private static Optional<CppSuperclassHierarchyExtractorPhase.SuperclassHierarchyValue> getParentHierarchy(ICheckContext context, String className) {
        return ((List)context.accessPhaseInvertedResult(CppSuperclassHierarchyExtractorPhase.class).apply(className)).stream().filter(x -> !x.getAdditionalInformation().hasSubClass()).findFirst();
    }

    private static boolean hasVirtualMethods(ShallowEntity entity) {
        for (ShallowEntity shallowEntity : entity.getChildrenOfType(EShallowEntityType.METHOD)) {
            if (!LanguageFeatureParser.CPP.isVirtual(shallowEntity) || DESTRUCTOR_SUBTYPES.contains(shallowEntity.getSubtype())) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverride(ShallowEntity destructor) {
        return TokenStreamUtils.containsAny((List)destructor.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.OVERRIDE});
    }
}

