/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.base.AvoidStringFormatInLogStatementsBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-cs-avoid-string-format-in-log-statement", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CsAvoidStringFormatInLogStatementCheck
extends AvoidStringFormatInLogStatementsBase {
    private static final String FINDING_MESSAGE_STRING_INTERPOLATION = "Avoid using String interpolation in log statements";
    private static final String FINDING_MESSAGE_STRING_FORMATTING = "Avoid using String formatting in log statements";
    private static final String STRING_INTERPOLATION_SIGN = "$\"";
    private static final String DOLLAR_AS_PART_OF_TEXT = "\\$\"";

    protected void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList entityTokens = entity.includedTokens();
        for (IToken currentToken : entityTokens) {
            ETokenType currentTokenType = currentToken.getType();
            String currentTokenText = currentToken.getText();
            if (currentTokenType == ETokenType.DOUBLE_ARROW) {
                return;
            }
            if (currentTokenText.contains(STRING_INTERPOLATION_SIGN) && !currentTokenText.contains(DOLLAR_AS_PART_OF_TEXT)) {
                this.buildFinding(FINDING_MESSAGE_STRING_INTERPOLATION, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            }
            if (currentTokenType != ETokenType.PLUS) continue;
            this.buildFinding(FINDING_MESSAGE_STRING_FORMATTING, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

