/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.clike.HashCodeAndEqualsCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;

@Check(id="cqse-override-get-hash-code-on-overriding-equals", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OverrideGetHashCodeOnOverridingEqualsCheck
extends HashCodeAndEqualsCheckBase {
    @Override
    protected String getEqualsName() {
        return "Equals";
    }

    @Override
    protected String getHashCodeName() {
        return "GetHashCode";
    }

    @Override
    protected String getMethodSelector(String name) {
        if (name.equals(this.getEqualsName())) {
            return "/TYPE[subtype('record')]/METHOD[subtype('method') and name-matches('" + name + "')] | METHOD[subtype('method') and name-matches('" + name + "') and modifiers('override')]";
        }
        return "METHOD[subtype('method') and name-matches('" + name + "') and modifiers('override')]";
    }

    @Override
    protected boolean createFindingForMissingEquals(ShallowEntity entity) {
        return !"record".equals(entity.getSubtype());
    }
}

