/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.formatting;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Check(id="cqse-invalid-character-in-identifier", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OPEN_CL, ELanguage.RUST, ELanguage.VB, ELanguage.COBOL, ELanguage.CS, ELanguage.ABAP, ELanguage.ADA, ELanguage.TEXT, ELanguage.XML, ELanguage.SQLSCRIPT, ELanguage.HANA_VIEW, ELanguage.PLSQL, ELanguage.PYTHON, ELanguage.TSQL, ELanguage.MATLAB, ELanguage.PHP, ELanguage.JAVASCRIPT, ELanguage.LINE, ELanguage.DELPHI, ELanguage.IEC61131, ELanguage.FORTRAN, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.OCAML, ELanguage.OSCRIPT, ELanguage.GROOVY, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.JAVADOC, ELanguage.ESQL, ELanguage.GO})
public class InvalidCharacterInIdentifierCheck
extends CheckImplementationBase {
    private static final Pattern INVALID_CHARACTER_PATTERN = Pattern.compile("(?i)[^ -~]");

    public void execute() throws CheckException {
        for (IToken token : this.context.getTokens(ECodeViewOption.FILTERED)) {
            if (token.getType() != ETokenType.IDENTIFIER) continue;
            this.checkIdentifier(token);
        }
    }

    private void checkIdentifier(IToken token) {
        Matcher matcher = INVALID_CHARACTER_PATTERN.matcher(token.getText());
        while (matcher.find()) {
            String match = matcher.group();
            int startOffset = token.getOffset() + matcher.start();
            String message = "Identifier contains invalid characters: " + match;
            int endOffset = startOffset + match.length() - 1;
            this.buildFinding(message, this.buildLocation().betweenOffsets(startOffset, endOffset, ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
        }
    }
}

