/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.hana_views;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.xml.XmlCheckBase;
import eu.cqse.check.xml.XmlCheckHandlerBase;
import eu.cqse.check.xml.XmlElementValueCheckHandlerBase;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Check(id="cqse-usage-of-column-engine", languages={ELanguage.HANA_VIEW})
public class UsageOfColumnEngineCheck
extends XmlCheckBase {
    private static final String CHECK_NAME = "Usage of column engine";
    private static final String ELEMENT_FORMULA = "formula";
    private static final String ATTRIBUTE_EXPRESSION_LANGUAGE = "expressionLanguage";
    private static final String LANGUAGE_COLUMN_ENGINE = "COLUMN_ENGINE";
    @CheckOption(name="Usage of column engine - relevant tokens", description="Comma separted list of relevant token types. This would restrict the check to onlyreport findings for expressions containing one of the specified token types. If nothing is specified here, any usage of Column Engine is reported.")
    private Set<String> relevantTokenTypeNames = new HashSet<String>();
    private EnumMap<ETokenType, String> relevantTokenTypes = new EnumMap(ETokenType.class);

    public void initialize() {
        for (String tokenTypeName : this.relevantTokenTypeNames) {
            this.relevantTokenTypes.put(ETokenType.valueOf((String)tokenTypeName.toUpperCase()), tokenTypeName);
        }
    }

    @Override
    public XmlCheckHandlerBase getHandler() {
        return new XmlElementValueCheckHandlerBase(ELEMENT_FORMULA){

            @Override
            protected void checkValue(String value) {
                if (!this.isColumnEngineLanguage()) {
                    return;
                }
                if (UsageOfColumnEngineCheck.this.relevantTokenTypes.isEmpty()) {
                    this.createFinding("Usage of column engine expression");
                }
                List tokens = ScannerUtils.getTokens((String)value, (ELanguage)ELanguage.JAVASCRIPT, (String)UsageOfColumnEngineCheck.this.context.getUniformPath());
                for (ETokenType tokenType : UsageOfColumnEngineCheck.this.relevantTokenTypes.keySet()) {
                    if (!TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{tokenType})) continue;
                    this.createFinding("Usage of column engine expression containing '" + UsageOfColumnEngineCheck.this.relevantTokenTypes.get(tokenType) + "'");
                }
            }

            private boolean isColumnEngineLanguage() {
                return UsageOfColumnEngineCheck.LANGUAGE_COLUMN_ENGINE.equalsIgnoreCase(this.getParentAttributeValue(UsageOfColumnEngineCheck.ATTRIBUTE_EXPRESSION_LANGUAGE));
            }
        };
    }
}

