/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-avoid-list-adding-itself", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AvoidListAddingItselfCheck
extends CheckImplementationBase {
    private static final String ADD_ALL = "addAll";
    private static final Set<String> LIST_TYPES = new HashSet<String>(Arrays.asList("java.util.List", "java.util.AbstractList", "java.util.AbstractSequentialList", "java.util.ArrayList", "javax.management.AttributeList", "java.util.concurrency.CopyOnWriteArrayList", "java.util.LinkedList", "javax.management.relation.RoleList", "javax.management.relation.RoleUnresolvedList", "java.util.Stack", "java.util.Vector"));

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List standardCandidates = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN});
        List classVariableParamCandidates = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.THIS, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.RPAREN});
        List<Integer> matchingStandardCandidates = this.findMatchingListCandidates(standardCandidates, (List<IToken>)tokens, entity);
        List<Integer> matchingClassVariableParamCandidates = this.findMatchingListCandidates(classVariableParamCandidates, (List<IToken>)tokens, entity);
        for (int index : matchingStandardCandidates) {
            this.checkOperands((List<IToken>)tokens, index + 1);
        }
        for (int index : matchingClassVariableParamCandidates) {
            this.checkOperands((List<IToken>)tokens, index + 1);
        }
    }

    private List<Integer> findMatchingListCandidates(List<Integer> candidates, List<IToken> tokens, ShallowEntity entity) throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        ScopedTypeLookup lookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        return CollectionUtils.filter(candidates, index -> {
            List calledObjectTokens = tokens.subList(0, (int)index);
            Optional isOfTypeList = typeResolver.isOfType(calledObjectTokens, LIST_TYPES, lookup, Collections.singleton("subList"));
            return isOfTypeList.isPresent() && ((IToken)tokens.get(index + 1)).getText().equalsIgnoreCase(ADD_ALL);
        });
    }

    private void checkOperands(List<IToken> tokens, int addOperatorIndex) {
        int firstParameterIndex = addOperatorIndex + 2;
        if (!AvoidListAddingItselfCheck.callerSequenceEqualsParameters(tokens, addOperatorIndex, firstParameterIndex)) {
            return;
        }
        int firstOperandIndex = addOperatorIndex - 2;
        if (firstOperandIndex < 0 || tokens.size() < firstParameterIndex + 1) {
            return;
        }
        IToken firstOperand = tokens.get(firstOperandIndex);
        this.buildFinding("Adding list type object " + MarkupUtils.formatAsSourceCode((String)firstOperand.getText()) + " to itself is not recommended.", this.buildLocation().forToken(firstOperand)).createAndStore();
    }

    private static boolean callerSequenceEqualsParameters(List<IToken> tokens, int addOperatorIndex, int firstParameterIndex) {
        int firstIndexOfCallerSequence = AvoidListAddingItselfCheck.getFirstIndexOfCallerSequence(tokens, addOperatorIndex);
        if (firstIndexOfCallerSequence == addOperatorIndex - 1 && !tokens.get(firstIndexOfCallerSequence).getType().equals((Object)ETokenType.IDENTIFIER)) {
            return false;
        }
        List<IToken> callingSequence = tokens.subList(firstIndexOfCallerSequence, addOperatorIndex - 1);
        for (int i = 0; i < callingSequence.size(); ++i) {
            if (callingSequence.get(i).getText().equals(tokens.get(firstParameterIndex + i).getText())) continue;
            return false;
        }
        return true;
    }

    private static int getFirstIndexOfCallerSequence(List<IToken> tokens, int addOperatorIndex) {
        HashSet<ETokenType> delimiter = new HashSet<ETokenType>(Arrays.asList(ETokenType.IDENTIFIER, ETokenType.DOT));
        for (int i = addOperatorIndex - 1; i > 0; --i) {
            if (delimiter.contains(tokens.get(i).getType())) continue;
            return i + 1;
        }
        return 0;
    }
}

