/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-correct-assert-that-assertions", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CorrectAssertThatAssertionsCheck
extends CheckImplementationBase {
    private boolean importsAssertJ = false;
    private boolean staticallyImportsAssertJ = false;
    private boolean importsHamcrest = false;
    private boolean staticallyImportsHamcrest = false;
    private static final String ASSERTJ_PACKAGE_NAME = "org.assertj.core.api";
    private static final String HAMCREST_PACKAGE_NAME = "org.hamcrest";
    private static final String ASSERTJ_ASSERTIONS = "Assertions";
    private static final String HAMCREST_MATCHER_ASSERT = "MatcherAssert";
    private static final String ASSERT_THAT = "assertThat";

    public void execute() throws CheckException {
        this.importsAssertJ = false;
        this.importsHamcrest = false;
        this.staticallyImportsAssertJ = false;
        this.staticallyImportsHamcrest = false;
        this.determineAssertJAndHamcrestUsageFromImports();
        if (!this.importsAssertJ && !this.staticallyImportsAssertJ) {
            return;
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (this.importsAssertJ && ASSERTJ_ASSERTIONS.equals(statement.getName())) {
                this.processEntity(statement);
            }
            if (!this.staticallyImportsAssertJ || !ASSERT_THAT.equals(statement.getName())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        if (tokens.isEmpty() || CorrectAssertThatAssertionsCheck.isExplicitHamcrestCall((List<IToken>)tokens) || CorrectAssertThatAssertionsCheck.isAnotherExplicitAssertJCall((List<IToken>)tokens)) {
            return;
        }
        int lastMethodTokenIndex = TokenStreamUtils.findMatchingOpeningToken((List)tokens, (int)(TokenStreamUtils.lastTokenMatching((List)tokens, (ITokenMatcher)ETokenType.RPAREN) - 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN) - 1;
        if (lastMethodTokenIndex == -1) {
            this.buildFinding("Illegal expression", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            return;
        }
        String lastMethod = ((IToken)tokens.get(lastMethodTokenIndex)).getText();
        if (lastMethod.equals("as")) {
            this.buildFinding("\"as(..)\" should not be the last method in the chain", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        } else if (lastMethod.equals(ASSERT_THAT)) {
            if (this.importsHamcrest || this.staticallyImportsHamcrest) {
                if (!CorrectAssertThatAssertionsCheck.isImplicitHamcrestCall((List<IToken>)tokens)) {
                    this.buildFinding("Illegal expression", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
                }
            } else {
                this.buildFinding("\"assertThat(..)\" should be followed by an assertion specification", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            }
        }
    }

    private void determineAssertJAndHamcrestUsageFromImports() throws CheckException {
        for (ShallowEntity topLevelEntity : this.context.getRootEntity(this.getCodeViewOption()).getChildren()) {
            if (topLevelEntity.getType() != EShallowEntityType.META) continue;
            String topLevelEntitySubType = topLevelEntity.getSubtype();
            String topLevelEntityName = topLevelEntity.getName();
            if (topLevelEntityName == null) continue;
            if (topLevelEntitySubType.equals("import")) {
                if (topLevelEntityName.startsWith(ASSERTJ_PACKAGE_NAME)) {
                    this.importsAssertJ = true;
                    continue;
                }
                if (!topLevelEntityName.startsWith(HAMCREST_PACKAGE_NAME)) continue;
                this.importsHamcrest = true;
                continue;
            }
            if (!topLevelEntitySubType.equals("static import")) continue;
            if (topLevelEntityName.startsWith(ASSERTJ_PACKAGE_NAME)) {
                this.staticallyImportsAssertJ = true;
                continue;
            }
            if (!topLevelEntityName.startsWith(HAMCREST_PACKAGE_NAME)) continue;
            this.staticallyImportsHamcrest = true;
        }
    }

    private static boolean isExplicitHamcrestCall(List<IToken> tokens) {
        int matcherAssertIndex = TokenStreamTextUtils.findFirst(tokens, (String)HAMCREST_MATCHER_ASSERT);
        int assertThatIndex = matcherAssertIndex + 2;
        return matcherAssertIndex != -1 && assertThatIndex < tokens.size() && tokens.get(assertThatIndex).getText().equals(ASSERT_THAT);
    }

    private static boolean isAnotherExplicitAssertJCall(List<IToken> tokens) {
        int assertionsIndex = TokenStreamTextUtils.findFirst(tokens, (String)ASSERTJ_ASSERTIONS);
        int assertThatIndex = assertionsIndex + 2;
        return assertionsIndex != -1 && assertThatIndex < tokens.size() && !tokens.get(assertThatIndex).getText().equals(ASSERT_THAT);
    }

    private static boolean isImplicitHamcrestCall(List<IToken> tokens) {
        int endIndex;
        int startIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LPAREN) + 1;
        List commaIndices = TokenStreamUtils.getTopLevelCommaIndices(tokens, (int)startIndex, (int)(endIndex = TokenStreamUtils.lastTokenMatching(tokens, (ITokenMatcher)ETokenType.RPAREN) - 1));
        return CorrectAssertThatAssertionsCheck.isHamcrestAssertThatWithTag(tokens, commaIndices) || CorrectAssertThatAssertionsCheck.isHamcrestAssertThatWithoutTag(commaIndices);
    }

    private static boolean isHamcrestAssertThatWithTag(List<IToken> tokens, List<Integer> commaIndices) {
        return commaIndices.size() == 2 && tokens.get(commaIndices.get(0) - 1).getType() == ETokenType.STRING_LITERAL;
    }

    private static boolean isHamcrestAssertThatWithoutTag(List<Integer> commaIndices) {
        return commaIndices.size() == 1;
    }
}

