/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-junit-assert-with-multiple-conditions", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JUnitAssertWithMultipleConditionsCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TokenStreamUtils.containsAny((List)statement.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.ANDAND, ETokenType.OROR, ETokenType.AND, ETokenType.OR, ETokenType.XOR})) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        String firstToken = ((IToken)entity.includedTokens().get(0)).getText();
        if (firstToken.startsWith("assertTrue") || firstToken.startsWith("assertFalse")) {
            this.buildFinding("More than one condition found in `" + firstToken + "` statement", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

