/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S4602", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SpringScanDefaultPackageCheck
extends CheckImplementationBase {
    private static final UnmodifiableMap<String, UnmodifiableSet<String>> ANNOTATIONS_AND_ATTRIBUTES = SpringScanDefaultPackageCheck.buildAnnotationsToAttributesMap();
    private static final String DEFAULT_PARAMETER_NAME = "value";
    private static final String CLASS_SUFFIX = ".class";
    private boolean isInDefaultPackage = false;
    private Collection<String> importedTypes = Collections.emptySet();

    private static UnmodifiableMap<String, UnmodifiableSet<String>> buildAnnotationsToAttributesMap() {
        HashMap<String, UnmodifiableSet> annotationsToAttributes = new HashMap<String, UnmodifiableSet>();
        UnmodifiableSet basePackageAttribute = UnmodifiableSet.of(Set.of(DEFAULT_PARAMETER_NAME, "basePackages", "basePackageClasses"));
        annotationsToAttributes.put("ComponentScan", basePackageAttribute);
        annotationsToAttributes.put("org.springframework.context.annotation.ComponentScan", basePackageAttribute);
        annotationsToAttributes.put("ServletComponentScan", basePackageAttribute);
        annotationsToAttributes.put("org.springframework.boot.web.servlet.ServletComponentScan", basePackageAttribute);
        UnmodifiableSet scanBasePackageAttribute = UnmodifiableSet.of(Set.of("scanBasePackages", "scanBasePackageClasses"));
        annotationsToAttributes.put("SpringBootApplication", scanBasePackageAttribute);
        annotationsToAttributes.put("org.springframework.boot.autoconfigure.SpringBootApplication", scanBasePackageAttribute);
        return UnmodifiableMap.of(annotationsToAttributes);
    }

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        this.isInDefaultPackage = LanguageFeatureParser.JAVA.getPackageName(ast).isEmpty();
        this.importedTypes = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)ast, Collections.singleton(EShallowEntityType.META), Collections.singleton("import")).stream().map(ShallowEntity::getName).collect(Collectors.toSet());
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            List annotations = CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)type);
            this.processAnnotations(annotations);
        }
    }

    private void processAnnotations(Collection<ShallowEntity> annotations) {
        for (ShallowEntity annotation : annotations) {
            if (!CLikeLanguageFeatureParserBase.isSpecificAnnotation((ShallowEntity)annotation, (Set)ANNOTATIONS_AND_ATTRIBUTES.keySet())) continue;
            this.processSingleAnnotation(annotation);
        }
    }

    private void processSingleAnnotation(ShallowEntity annotation) {
        String annotationName = annotation.getName();
        if (!LanguageFeatureParser.JAVA.annotationHasParameters(annotation)) {
            if (this.isInDefaultPackage) {
                this.buildFinding("Remove the annotation `@%s` or move the annotated class out of the default package".formatted(MarkupUtils.escapeMarkdownRelevantSymbols((String)annotationName)), this.buildLocation().forEntity(annotation)).createAndStore();
            }
        } else {
            Set relevantParameters = (Set)ANNOTATIONS_AND_ATTRIBUTES.get((Object)annotationName);
            if (relevantParameters != null) {
                this.processSingleAnnotationWithParameters(annotation, relevantParameters);
            }
        }
    }

    private void processSingleAnnotationWithParameters(ShallowEntity annotation, Set<String> relevantParameters) {
        List paramTokens = LanguageFeatureParser.JAVA.getAnnotationParameterTokens(annotation);
        if (paramTokens.isEmpty()) {
            return;
        }
        Map<String, List<ParameterValue>> parameters = this.extractAnnotationParameters(paramTokens, relevantParameters);
        for (List<ParameterValue> values : parameters.values()) {
            values.stream().filter(ParameterValue::isEmptyString).forEach(v -> this.buildFinding("Define packages to scan. Don't rely on the default package", this.buildLocation().forTokens(v.getTokens())).createAndStore());
            values.stream().filter(ParameterValue::isClassReferenceInDefaultPackage).forEach(v -> this.buildFinding("Remove the annotation `@%s` or move the `%s` class out of the default package".formatted(MarkupUtils.escapeMarkdownRelevantSymbols((String)annotation.getName()), MarkupUtils.escapeMarkdownRelevantSymbols((String)v.simpleClassName())), this.buildLocation().forTokens(v.getTokens())).createAndStore());
        }
    }

    private Map<String, List<ParameterValue>> extractAnnotationParameters(List<IToken> paramTokens, Set<String> relevantParameters) {
        HashMap<String, List<ParameterValue>> parameters = new HashMap<String, List<ParameterValue>>();
        List individualParameterTokens = TokenStreamUtils.splitWithNesting(paramTokens, (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE);
        for (List parameterTokens : individualParameterTokens) {
            List<ParameterValue> extractedValues;
            if (parameterTokens.isEmpty()) continue;
            ParameterNameAndValue nameAndValue = SpringScanDefaultPackageCheck.extractParameterNameAndValue(parameterTokens);
            if (!relevantParameters.contains(nameAndValue.name) || nameAndValue.valueTokens.isEmpty() || (extractedValues = this.extractParameterValues(nameAndValue.valueTokens)).isEmpty()) continue;
            parameters.put(nameAndValue.name, extractedValues);
        }
        return parameters;
    }

    private static ParameterNameAndValue extractParameterNameAndValue(List<IToken> parameterTokens) {
        String paramName = DEFAULT_PARAMETER_NAME;
        List<IToken> valueTokens = parameterTokens;
        int equalsIndex = TokenStreamUtils.firstTokenMatching(parameterTokens, (ITokenMatcher)ETokenType.EQ);
        if (equalsIndex > 0 && parameterTokens.get(equalsIndex - 1).getType() == ETokenType.IDENTIFIER) {
            paramName = parameterTokens.get(equalsIndex - 1).getText();
            valueTokens = parameterTokens.subList(equalsIndex + 1, parameterTokens.size());
        }
        return new ParameterNameAndValue(paramName, valueTokens);
    }

    private List<ParameterValue> extractParameterValues(List<IToken> valueTokens) {
        ArrayList<ParameterValue> extractedValues = new ArrayList<ParameterValue>();
        if (valueTokens.getFirst().getType() == ETokenType.LBRACE) {
            this.extractArrayParameterValues(valueTokens, extractedValues);
        } else {
            ParameterValue value = this.extractSingleParameterValue(valueTokens);
            if (value != null) {
                extractedValues.add(value);
            }
        }
        return extractedValues;
    }

    private void extractArrayParameterValues(List<IToken> valueTokens, List<ParameterValue> extractedValues) {
        List arrayContentTokens = TokenStreamUtils.tokensBetween(valueTokens, (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE);
        if (arrayContentTokens.isEmpty()) {
            return;
        }
        List arrayElementTokens = TokenStreamUtils.splitWithNesting((List)arrayContentTokens, (ETokenType)ETokenType.COMMA, (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE);
        for (List elementTokens : arrayElementTokens) {
            this.extractSingleArrayValueElement(elementTokens, extractedValues);
        }
    }

    private void extractSingleArrayValueElement(List<IToken> elementTokens, List<ParameterValue> extractedValues) {
        if (elementTokens.isEmpty()) {
            return;
        }
        ParameterValue value = this.extractSingleParameterValue(elementTokens);
        if (value != null) {
            extractedValues.add(value);
        }
    }

    private @Nullable ParameterValue extractSingleParameterValue(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return null;
        }
        if (tokens.getFirst().getType() == ETokenType.STRING_LITERAL) {
            String text = tokens.getFirst().getText();
            text = StringUtils.removeDoubleQuotes((String)text);
            return new ParameterValue(tokens, text);
        }
        if (ParameterValue.looksLikeClassReference(tokens)) {
            return new ParameterValue(tokens, TokenStreamTextUtils.concatTokenTexts(tokens));
        }
        return null;
    }

    private record ParameterNameAndValue(String name, List<IToken> valueTokens) {
    }

    private final class ParameterValue {
        private final List<IToken> tokens;
        private final String value;
        private final boolean isClassReference;

        public ParameterValue(List<IToken> tokens, String value) {
            this.tokens = tokens;
            this.value = value;
            this.isClassReference = ParameterValue.looksLikeClassReference(tokens);
        }

        public static boolean looksLikeClassReference(List<IToken> tokens) {
            return TokenStreamUtils.endsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DOT, ETokenType.CLASS_LITERAL});
        }

        public List<IToken> getTokens() {
            return this.tokens;
        }

        public String simpleClassName() {
            String className = this.value;
            if (this.isQualifiedClassReference()) {
                className = StringUtils.getLastPart((String)className, (String)".", (int)2);
            }
            return StringUtils.stripSuffix((String)className, (String)SpringScanDefaultPackageCheck.CLASS_SUFFIX);
        }

        public boolean isEmptyString() {
            return StringUtils.isEmpty((String)this.value) && this.tokens.size() == 1 && this.tokens.getFirst().getType() == ETokenType.STRING_LITERAL;
        }

        private boolean isQualifiedClassReference() {
            return this.isClassReference && TokenStreamUtils.count(this.tokens, (ETokenType)ETokenType.DOT) > 2;
        }

        private boolean isImportedClass() {
            String nameWithoutClassPostfix = StringUtils.stripSuffix((String)this.value, (String)SpringScanDefaultPackageCheck.CLASS_SUFFIX);
            return SpringScanDefaultPackageCheck.this.importedTypes.stream().anyMatch(importedClass -> importedClass.endsWith(nameWithoutClassPostfix));
        }

        public boolean isClassReferenceInDefaultPackage() {
            if (!this.isClassReference || !SpringScanDefaultPackageCheck.this.isInDefaultPackage) {
                return false;
            }
            if (this.isImportedClass()) {
                return false;
            }
            return !this.isQualifiedClassReference();
        }

        public String toString() {
            return "ParameterValue[tokens='" + TokenStreamTextUtils.concatTokenTexts(this.tokens) + "', value='" + this.value + "']";
        }
    }
}

