/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="java:S5960", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidAssertionsInProductionCodeCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Remove this assertion from production code.";

    public void execute() throws CheckException {
        if (this.context.isTestCode()) {
            return;
        }
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List importStatements = LanguageFeatureParser.JAVA.getImportStatements(ast);
        Set staticImportedAssertionMethods = LanguageFeatureParser.JAVA.extractStaticImportedAssertions(importStatements);
        Set importedAssertionTypes = LanguageFeatureParser.JAVA.extractImportedAssertionsTypes(importStatements);
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.analyzeMethodCalls(statement, importedAssertionTypes, staticImportedAssertionMethods);
        }
    }

    private void analyzeMethodCalls(ShallowEntity statement, Set<String> importedAssertionTypes, Set<String> staticImportedAssertionMethods) {
        for (IToken assertionCall : LanguageFeatureParser.JAVA.getAssertionCalls(statement, importedAssertionTypes, staticImportedAssertionMethods)) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(assertionCall)).createAndStore();
        }
    }
}

