/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S5786", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class TestClassesAndMethodsShouldHavePackageVisibilityCheck
extends CheckImplementationBase {
    private static final Set<String> JUNIT5_TEST_ANNOTATIONS = Set.of("org.junit.jupiter.api.Test", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.ParameterizedTest");
    private static final String OVERRIDE_ANNOTATION = "Override";

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        Set<String> junit5Annotations = TestClassesAndMethodsShouldHavePackageVisibilityCheck.getImportedJUnitAnnotations(ast);
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).forEach(t -> this.handleType((ShallowEntity)t, junit5Annotations));
    }

    private static Set<String> getImportedJUnitAnnotations(List<ShallowEntity> entities) {
        HashSet<String> result = new HashSet<String>(JUNIT5_TEST_ANNOTATIONS);
        Set imports = LanguageFeatureParser.JAVA.getImports(entities);
        for (String type : JUNIT5_TEST_ANNOTATIONS) {
            if (!imports.contains(type)) continue;
            String simpleName = (String)StringUtils.splitAtLast((String)type, (char)'.').getSecond();
            result.add(simpleName);
        }
        return result;
    }

    private void handleType(ShallowEntity type, Set<String> junit5Annotations) {
        if (!JavaLanguageFeatureParser.isTestClass((ShallowEntity)type) || CLikeLanguageFeatureParserBase.isAbstract((ShallowEntity)type) || TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(type, ETokenType.PRIVATE) && TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(type, ETokenType.STATIC)) {
            return;
        }
        type.getChildren().stream().filter(child -> child.getType() == EShallowEntityType.METHOD).toList().forEach(m -> this.handleMethod((ShallowEntity)m, junit5Annotations));
        if (TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(type, ETokenType.PUBLIC) && TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasNoPublicChildren(type) || TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(type, ETokenType.PRIVATE) || TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(type, ETokenType.PROTECTED)) {
            this.buildFinding(TestClassesAndMethodsShouldHavePackageVisibilityCheck.createMessage(type), this.buildLocation().forEntityFirstLine(type)).createAndStore();
        }
    }

    private void handleMethod(ShallowEntity method, Set<String> junit5Annotations) {
        if (!JavaLanguageFeatureParser.hasAnnotation((ShallowEntity)method, junit5Annotations)) {
            return;
        }
        if (JavaLanguageFeatureParser.hasAnnotation((ShallowEntity)method, Set.of(OVERRIDE_ANNOTATION))) {
            return;
        }
        if (TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(method, ETokenType.PUBLIC) || TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(method, ETokenType.PROTECTED)) {
            this.buildFinding(TestClassesAndMethodsShouldHavePackageVisibilityCheck.createMessage(method), this.buildLocation().forEntityFirstLine(method)).createAndStore();
        }
    }

    private static boolean hasNoPublicChildren(ShallowEntity entity) {
        return entity.getChildren().stream().noneMatch(child -> TestClassesAndMethodsShouldHavePackageVisibilityCheck.hasVisibility(child, ETokenType.PUBLIC));
    }

    private static boolean hasVisibility(ShallowEntity type, ETokenType visibility) {
        return TokenStreamUtils.contains((List)type.ownStartTokens(), (ETokenType)visibility);
    }

    private static String createMessage(ShallowEntity entity) {
        return "`%s` should have package visibility".formatted(entity.getName());
    }
}

