/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.matlab.MatlabFunctionDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;

public class MatlabCheckUtils {
    public static List<IToken> getFunctionDeclarationTokens(List<IToken> tokens, Integer functionTokenIndex) {
        int functionDeclarationEndIndex = TokenStreamUtils.firstTokenMatching(tokens, (int)functionTokenIndex, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.EOL}));
        List<IToken> declarationTokens = tokens.subList(functionTokenIndex, functionDeclarationEndIndex + 1);
        return MatlabCheckUtils.filterDeclarationTokens(declarationTokens);
    }

    public static List<IToken> filterDeclarationTokens(List<IToken> declarationTokens) {
        return declarationTokens.stream().filter(t -> MatlabFunctionDeclaration.DECLARATION_RELEVANT_TOKEN_TYPES.contains(t.getType())).collect(Collectors.toList());
    }

    public static boolean isEmptyCommentLine(IToken commentToken) {
        return commentToken.getText().matches("%\\s*");
    }

    public static boolean hasWords(IToken commentToken) {
        return Patterns.SINGLE_WORD_CHARACTER.matcher(commentToken.getText()).find();
    }

    public static String getCommentContent(IToken commentToken) {
        String content = commentToken.getText();
        if (commentToken.getType() == ETokenType.TRADITIONAL_COMMENT) {
            content = StringUtils.stripPrefix((String)content, (String)"%{");
            content = StringUtils.stripSuffix((String)content, (String)"%}");
        } else {
            content = StringUtils.stripPrefix((String)content, (String)"%");
        }
        return content;
    }

    public static List<ShallowEntity> getClassMethods(ShallowEntity classEntity) {
        ArrayList<ShallowEntity> methods = new ArrayList<ShallowEntity>();
        for (ShallowEntity child : classEntity.getChildren()) {
            if (!child.getSubtype().equals("methods")) continue;
            methods.addAll((Collection<ShallowEntity>)child.getChildren());
            break;
        }
        return methods;
    }

    public static String getTrimmedCommentContent(IToken commentToken) {
        return MatlabCheckUtils.getCommentContent(commentToken).trim();
    }

    public static String[] getWordsSeperatedByWhiteSpace(IToken commentToken) {
        return MatlabCheckUtils.getTrimmedCommentContent(commentToken).split("\\s+");
    }

    public static boolean isConstructor(ShallowEntity methodEntity) {
        if (methodEntity.getType() != EShallowEntityType.METHOD) {
            return false;
        }
        Optional parentEntity = ShallowEntityTraversalUtils.findParentEntity((ShallowEntity)methodEntity, entity -> entity.getType() == EShallowEntityType.TYPE && Objects.equals(entity.getSubtype(), "class"));
        if (parentEntity.isPresent()) {
            String className = ((ShallowEntity)parentEntity.get()).getName();
            return className != null && className.equals(methodEntity.getName());
        }
        return false;
    }
}

