/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PythonMainMethodUtils {
    private static final String MODULE_NAME_PATTERN = "^__name__$";
    private static final String MAIN_MODULE_NAME_PATTERN = "^\"__main__\"$";
    private static final TokenPattern MAIN_METHOD_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IF}).alternative(new Object[]{new TokenPattern().regex("^__name__$"), ETokenType.EQEQ, new TokenPattern().regex("^\"__main__\"$"), new TokenPattern().regex("^\"__main__\"$"), ETokenType.EQEQ, new TokenPattern().regex("^__name__$")});

    public static boolean isInMainMethod(ShallowEntity entity, Map<Integer, Boolean> entityInMainCache) {
        if (entity.getParent() == null) {
            entityInMainCache.put(entity.getStartTokenIndex(), false);
            return false;
        }
        ShallowEntity parent = entity.getParent();
        int key = parent.getStartTokenIndex();
        if (entityInMainCache.containsKey(key)) {
            return entityInMainCache.get(key);
        }
        if (PythonMainMethodUtils.isMainMethod(parent)) {
            entityInMainCache.put(key, true);
            return true;
        }
        return PythonMainMethodUtils.isInMainMethod(parent, entityInMainCache);
    }

    public static boolean isMainMethod(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        return MAIN_METHOD_PATTERN.matchAtStartOf((List)tokens) != null;
    }
}

