/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python.compatibility.python23;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternBase;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStream;
import eu.cqse.check.python.compatibility.ImportAwarePythonCompatibiltiyCheckBase;
import eu.cqse.check.python.compatibility.PythonImportAwareFindingsPattern;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-string-compatibility-python23", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class StringCompatibilityPython23Check
extends ImportAwarePythonCompatibiltiyCheckBase {
    private static TokenPattern getFindingPattern() {
        return new TokenPattern().sequence(new Object[]{new TokenPatternBase(){

            protected TokenPatternMatch matchesLocally(TokenStream stream) {
                if (stream.isExhausted() || stream.peekCurrent().getType() != ETokenType.STRING_LITERAL || StringUtils.startsWithOneOf((String)stream.next().getText(), (String[])new String[]{"b", "u"})) {
                    return null;
                }
                return 1.createMatch((TokenStream)stream);
            }
        }}).group(0);
    }

    private String getFindingMessage(List<IToken> tokens) {
        return "String literal " + MarkupUtils.formatAsSourceCode((String)StringUtils.truncateWithEllipsis((String)TokenStreamTextUtils.concatTokenTexts(tokens), (int)64)) + " should be prefixed with `u` for unicode text or `b` for binary data";
    }

    @Override
    protected List<PythonImportAwareFindingsPattern> getFindingPatterns() {
        return Collections.singletonList(new PythonImportAwareFindingsPattern(StringCompatibilityPython23Check.getFindingPattern(), "__future__.unicode_literals", this::getFindingMessage));
    }
}

