/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import com.google.common.collect.ImmutableSet;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.maab.na_0005", languages={ELanguage.SIMULINK})
public class SimulinkBlockPortNameVisibilityCheck
extends CheckImplementationBase {
    @CheckOption(name="Blocks must have visible port names", description="If true, all block port names must be visible. Otherwise, all block port names must be hidden.")
    private boolean portNamesMustBeVisible = true;
    @CheckOption(name="Excluded source types", description="A list of source types that are excluded from the check.", multilineText=true)
    private Set<String> excludedSourceTypes = new HashSet<String>();
    private static final FindingPropertyList RECOMMENDED_ACTION_PORT_BLOCKS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the visibility of the port name.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SUBSYSTEM_PORT_LABELS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the 'Show port labels' parameter of the subsystem.");
    private static final FindingPropertyList RECOMMENDED_ACTION_SUBSYSTEM_PORT_BLOCKS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Adjust the visibility of all port names in the subsystem.");
    private static final Set<String> PARAMETERS_FOR_VISIBLE_PORT_NAMES = ImmutableSet.of((Object)"FromPortIcon", (Object)"FromPortBlockName", (Object)"on", (Object)"SignalName");
    private static final Set<String> TYPES_WITH_PORT_LABELS = ImmutableSet.of((Object)"SubSystem", (Object)"Reference");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String sourceType = block.getSourceType();
            if (sourceType != null && this.excludedSourceTypes.contains(sourceType)) continue;
            if (TYPES_WITH_PORT_LABELS.contains(block.getType())) {
                this.checkVisibilityOfSubsystemPortLabels(block);
                continue;
            }
            if (!SimulinkUtils.isInport((SimulinkBlock)block) && !SimulinkUtils.isOutport((SimulinkBlock)block)) continue;
            this.checkVisibilityOfPortBlockNames(block);
        }
    }

    private void checkVisibilityOfSubsystemPortLabels(SimulinkBlock block) {
        if (SimulinkBlockPortNameVisibilityCheck.isStandardLibraryBlock((SimulinkElementBase)block)) {
            return;
        }
        boolean portLabelsVisible = SimulinkBlockPortNameVisibilityCheck.portLabelsAreVisible(block);
        boolean visibilityOfAllPortNamesCorrect = this.visibilityOfAllPortNamesCorrect(block);
        QualifiedNameLocation findingLocation = this.buildLocation().forSimulinkBlock(block);
        if (this.portNamesMustBeVisible) {
            if (!portLabelsVisible) {
                this.buildFinding("Subsystem port labels shall be visible", (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION_SUBSYSTEM_PORT_LABELS).createAndStore();
            } else if (!visibilityOfAllPortNamesCorrect) {
                this.buildFinding("All port names in the subsystem shall be visible", (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION_SUBSYSTEM_PORT_BLOCKS).createAndStore();
            }
        } else if (!block.isOfType("SubSystem") || block.getDeclaredParameter("SFBlockType") != null) {
            if (portLabelsVisible) {
                this.buildFinding("Subsystem port labels shall be hidden", (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION_SUBSYSTEM_PORT_LABELS).createAndStore();
            }
        } else if (portLabelsVisible && !visibilityOfAllPortNamesCorrect) {
            this.buildFinding("Subsystem port labels shall be hidden", (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION_SUBSYSTEM_PORT_LABELS).createAndStore();
        }
    }

    private void checkVisibilityOfPortBlockNames(SimulinkBlock block) {
        if (SimulinkBusUtils.isBusElementPort((SimulinkBlock)block) && this.portNamesMustBeVisible) {
            return;
        }
        if (block.hasVisibleName() != this.portNamesMustBeVisible) {
            String chosenVisibility = this.portNamesMustBeVisible ? "visible" : "hidden";
            this.buildFinding("Port block names shall be " + chosenVisibility, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_PORT_BLOCKS).createAndStore();
        }
    }

    private static boolean portLabelsAreVisible(SimulinkBlock block) {
        String portNameVisibility = block.getParameter("ShowPortLabels");
        return portNameVisibility == null || PARAMETERS_FOR_VISIBLE_PORT_NAMES.contains(portNameVisibility);
    }

    private boolean visibilityOfAllPortNamesCorrect(SimulinkBlock block) {
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            boolean nameIsHidden;
            if (!SimulinkUtils.isUserVisible((SimulinkBlock)subBlock) || !SimulinkUtils.isInport((SimulinkBlock)subBlock) && !SimulinkUtils.isOutport((SimulinkBlock)subBlock) || SimulinkBusUtils.isBusElementPort((SimulinkBlock)subBlock) || (nameIsHidden = "off".equals(subBlock.getParameter("ShowName"))) != this.portNamesMustBeVisible) continue;
            return false;
        }
        return true;
    }

    private static boolean isStandardLibraryBlock(SimulinkElementBase block) {
        return "SL".equals(block.getParameter("SourceProductBaseCode"));
    }
}

