/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.phases;

import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public final class ReferencedItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EReferencedItemType type;
    private final String target;

    public ReferencedItem(EReferencedItemType type, String target) {
        this.type = Objects.requireNonNull(type);
        this.target = Objects.requireNonNull(target);
    }

    public String toStorageString() {
        return this.type.storageKey + this.target;
    }

    public String getTarget() {
        return this.target;
    }

    public EReferencedItemType getType() {
        return this.type;
    }

    public static ReferencedItem fromStorageString(String storedString) {
        for (EReferencedItemType type : EReferencedItemType.values()) {
            if (!storedString.startsWith(type.storageKey)) continue;
            return new ReferencedItem(type, StringUtils.stripPrefix((String)storedString, (String)type.storageKey));
        }
        CCSMAssert.fail((String)("Could not load stored ReferenceItem from string " + storedString));
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ReferencedItem otherItem = (ReferencedItem)other;
        return Objects.equals(this.target, otherItem.target) && Objects.equals((Object)this.type, (Object)otherItem.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.target, this.type});
    }

    @IndexValueClass
    public static enum EReferencedItemType {
        DATA_DICTIONARY("SLDD_NAME:", "Data dictionary"),
        BLOCK_IN_LIBRARY("LIB_BLOCK:", "Library block"),
        MODEL_FILE("MODEL_NAME:", "Model file"),
        MODEL_SIMPLE_FILE_NAME("MODEL_SIMPLE_FILE_NAME:", "Simple model file"),
        DICTIONARY_SIMPLE_FILE_NAME("DICTIONARY_SIMPLE_FILE_NAME:", "Dictionary file name");

        private final String storageKey;
        private final String displayName;

        private EReferencedItemType(String storageKey, String displayName) {
            this.storageKey = storageKey;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

