/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlLikeCustomCheckUtils {
    public static List<ShallowEntity> selectStatementsOrCursorsPerformingSelect(ShallowEntity rootEntity) {
        ArrayList<ShallowEntity> selectedEntities = new ArrayList<ShallowEntity>();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singletonList(rootEntity), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!statement.getSubtype().equals("SQL") || !"select".equals(statement.getName())) continue;
            selectedEntities.add(statement);
        }
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType(Collections.singletonList(rootEntity), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            if (!attribute.getSubtype().equals("cursor") || !TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.SELECT)) continue;
            selectedEntities.add(attribute);
        }
        return selectedEntities;
    }

    public static List<IToken> extractSelect(ShallowEntity selectOrCursor) {
        Object tokens = selectOrCursor.ownStartTokens();
        if (selectOrCursor.getSubtype().equals("cursor")) {
            tokens = tokens.subList(TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.SELECT), tokens.size());
        }
        return tokens;
    }
}

