/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.ProperTextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnchor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.Identikit;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileWithStubSupport;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFile containingFile, @NotNull Identikit.ByAnchor identikit) {
        if (anchor2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            AnchorElementInfo.$$$reportNull$$$0(1);
        }
        if (identikit == null) {
            AnchorElementInfo.$$$reportNull$$$0(2);
        }
        super(ProperTextRange.create(anchor2.getTextRange()), identikit, containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor2, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType<?, ?> stubElementType) {
        if (anchor2 == null) {
            AnchorElementInfo.$$$reportNull$$$0(3);
        }
        if (containingFile == null) {
            AnchorElementInfo.$$$reportNull$$$0(4);
        }
        if (stubElementType == null) {
            AnchorElementInfo.$$$reportNull$$$0(5);
        }
        super(null, Identikit.fromTypes(anchor2.getClass(), stubElementType, LanguageUtil.getRootLanguage(containingFile)), containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor2 instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor2;
    }

    private static long pack(int stubId, @Nullable IStubElementType<?, ?> stubElementType) {
        short index2;
        short s = index2 = stubElementType == null ? (short)0 : stubElementType.getIndex();
        assert (index2 >= 0) : "Unregistered token types not allowed here: " + stubElementType;
        return (long)stubId | (long)index2 << 32;
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement(@NotNull SmartPointerManagerImpl manager) {
        long typeAndId;
        int stubId;
        if (manager == null) {
            AnchorElementInfo.$$$reportNull$$$0(6);
        }
        if ((stubId = (int)(typeAndId = this.myStubElementTypeAndId)) != -1) {
            PsiFile file2 = this.restoreFile(manager);
            if (!(file2 instanceof PsiFileWithStubSupport)) {
                return null;
            }
            short index2 = (short)(typeAndId >> 32);
            IStubElementType stubElementType = (IStubElementType)IElementType.find(index2);
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file2, stubId, stubElementType, false);
        }
        return super.restoreElement(manager);
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other, @NotNull SmartPointerManagerImpl manager) {
        if (other == null) {
            AnchorElementInfo.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            AnchorElementInfo.$$$reportNull$$$0(8);
        }
        if (other instanceof AnchorElementInfo) {
            if (!this.getVirtualFile().equals(other.getVirtualFile())) {
                return false;
            }
            long packed1 = this.myStubElementTypeAndId;
            long packed2 = ((AnchorElementInfo)other).myStubElementTypeAndId;
            if (packed1 != -1L && packed2 != -1L) {
                return packed1 == packed2;
            }
            if (packed1 != -1L || packed2 != -1L) {
                return ReadAction.compute(() -> Comparing.equal(this.restoreElement(manager), other.restoreElement(manager)));
            }
        }
        return super.pointsToTheSameElementAs(other, manager);
    }

    @Override
    public void fastenBelt(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            AnchorElementInfo.$$$reportNull$$$0(9);
        }
        if (this.getStubId() != -1) {
            this.switchToTree(manager);
        }
        super.fastenBelt(manager);
    }

    private void switchToTree(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            AnchorElementInfo.$$$reportNull$$$0(10);
        }
        PsiElement element = this.restoreElement(manager);
        SmartPointerTracker tracker = manager.getTracker(this.getVirtualFile());
        if (element != null && tracker != null) {
            tracker.switchStubToAst(this, element);
        }
    }

    void switchToTreeRange(@NotNull PsiElement element) {
        if (element == null) {
            AnchorElementInfo.$$$reportNull$$$0(11);
        }
        this.switchToAnchor(element);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    @Override
    public Segment getRange(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            AnchorElementInfo.$$$reportNull$$$0(12);
        }
        if (this.getStubId() != -1) {
            this.switchToTree(manager);
        }
        return super.getRange(manager);
    }

    @Override
    @Nullable
    public TextRange getPsiRange(@NotNull SmartPointerManagerImpl manager) {
        if (manager == null) {
            AnchorElementInfo.$$$reportNull$$$0(13);
        }
        if (this.getStubId() != -1) {
            this.switchToTree(manager);
        }
        return super.getPsiRange(manager);
    }

    @Override
    public String toString() {
        return super.toString() + ",stubId=" + this.getStubId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identikit";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubElementType";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/AnchorElementInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "pointsToTheSameElementAs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fastenBelt";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "switchToTree";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "switchToTreeRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

