/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.index.admin.instance_comparison.option.IInstanceComparisonAcceptableDeviationsOption;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import java.util.Map;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="instance-comparison-maintenance-log", name="Maintenance Log Errors", type=EOptionType.SERVER, category=EOptionCategory.INSTANCE_COMPARISON, orderingHint=600)
@IndexValueClass(containedInBackup=true)
public class InstanceComparisonMaintenanceLogOption
implements IInstanceComparisonAcceptableDeviationsOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID = "instance-comparison-maintenance-log";
    @JsonProperty(value="maintenanceWorkerLogs")
    @OptionFieldDescription(name="Accepted Deviation for maintenance worker logs", description="How large the deviation of the number of work logs of a single trigger may be compared to the remote number of logs. The specification is in decimal numbers.")
    public double maintenanceWorkerLogs = 0.01;

    @Override
    public InstanceComparisonContributionBase.AcceptedComparisonDeviations getAcceptedComparisonDeviations() {
        return new InstanceComparisonContributionBase.AcceptedComparisonDeviations(0.0, Map.of("Maintenance Worker Log Errors", this.maintenanceWorkerLogs), (PairList<Pattern, Double>)PairList.emptyPairList());
    }

    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (this.maintenanceWorkerLogs < 0.0) {
            return "Acceptable deviation of maintenance worker logs must be greater than or equal 0.";
        }
        return null;
    }
}

