/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.DetailedInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
class TestGapAnalysisComparisonDetailContribution
implements IDetailedInstanceComparisonContribution {
    private static final long serialVersionUID = 1L;
    private static final Comparator<TgaInformation> UNCHANGED_LAST = (i1, i2) -> {
        if (i1.getTestGapState() == i2.getTestGapState()) {
            return 0;
        }
        if (i1.getTestGapState() == ETestGapState.UNCHANGED) {
            return 1;
        }
        if (i2.getTestGapState() == ETestGapState.UNCHANGED) {
            return -1;
        }
        return 0;
    };
    private static final String END_COMMIT_PROPERTY = "endCommit";
    private static final String TGA_INFORMATION_PROPERTY = "tgaInformation";
    @JsonProperty(value="endCommit")
    private final @NonNull CommitDescriptor endCommit;
    @JsonProperty(value="tgaInformation")
    private final @NonNull Map<String, List<TgaInformation>> tgaInformation;

    @JsonCreator
    TestGapAnalysisComparisonDetailContribution(@JsonProperty(value="endCommit") @NonNull CommitDescriptor endCommit, @JsonProperty(value="tgaInformation") @NonNull Map<String, List<TgaInformation>> tgaInformation) {
        CCSMAssert.isNotNull((Object)endCommit, () -> String.format("Expected \"%s\" to be not null", END_COMMIT_PROPERTY));
        CCSMAssert.isNotNull(tgaInformation, () -> String.format("Expected \"%s\" to be not null", TGA_INFORMATION_PROPERTY));
        this.endCommit = endCommit;
        this.tgaInformation = tgaInformation;
    }

    public TestGapAnalysisComparisonDetailContribution(@NonNull CommitDescriptor endCommit) {
        CCSMAssert.isNotNull((Object)endCommit, () -> String.format("Expected \"%s\" to be not null", END_COMMIT_PROPERTY));
        this.endCommit = endCommit;
        this.tgaInformation = new HashMap<String, List<TgaInformation>>();
    }

    @Override
    public @NonNull Map<String, @Nullable DetailedInstanceComparisonValue> getDetailedValues(String key) {
        return this.asDetailedValues(this.tgaInformation.getOrDefault(key, Collections.emptyList()));
    }

    public void addTgaAssessment(@NonNull AssessedTgaData tgaData) {
        CCSMAssert.isNotNull((Object)tgaData, () -> String.format("Expected \"%s\" to be not null", "tgaData"));
        this.addAssessment("30 days TGA", tgaData);
    }

    public void addExecutionAssessment(@NonNull AssessedTgaData executionData) {
        CCSMAssert.isNotNull((Object)executionData, () -> String.format("Expected \"%s\" to be not null", "executionData"));
        this.addAssessment("Executed methods", executionData);
    }

    private void addAssessment(String key, AssessedTgaData tgaAssessment) {
        List tgaPerKey = this.tgaInformation.computeIfAbsent(key, ignored -> new ArrayList());
        for (AssessedTgaData.AssessedMethodData method : tgaAssessment.getMethods()) {
            tgaPerKey.add(TgaInformation.of(method));
        }
    }

    private Map<String, DetailedInstanceComparisonValue> asDetailedValues(List<TgaInformation> executionInformation) {
        LinkedHashMap<String, DetailedInstanceComparisonValue> result = new LinkedHashMap<String, DetailedInstanceComparisonValue>();
        for (TgaInformation information : CollectionUtils.sort(executionInformation, UNCHANGED_LAST)) {
            result.put(TestGapAnalysisComparisonDetailContribution.makeComparableKey(information), DetailedInstanceComparisonValue.ofMethodExecution(information.getLocation(), information.getMethodName(), this.endCommit, information.getTestGapState()));
        }
        return result;
    }

    private static String makeComparableKey(TgaInformation tgaInformation) {
        return String.join((CharSequence)"-", tgaInformation.getTestGapState().name(), tgaInformation.getLocation().getUniformPath(), tgaInformation.getMethodName());
    }

    @IndexValueClass
    private static class TgaInformation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String LOCATION_PROPERTY = "location";
        private static final String METHOD_NAME_PROPERTY = "methodName";
        private static final String TEST_GAP_STATE_PROPERTY = "testGapState";
        @JsonProperty(value="location")
        private final @NonNull MethodLocation location;
        @JsonProperty(value="methodName")
        private final @NonNull String methodName;
        @JsonProperty(value="testGapState")
        private final @NonNull ETestGapState testGapState;

        @JsonCreator
        TgaInformation(@JsonProperty(value="location") @NonNull MethodLocation location, @JsonProperty(value="methodName") @NonNull String methodName, @JsonProperty(value="testGapState") @NonNull ETestGapState testGapState) {
            CCSMAssert.isNotNull((Object)location, () -> String.format("Expected \"%s\" to be not null", LOCATION_PROPERTY));
            CCSMAssert.isNotNull((Object)methodName, () -> String.format("Expected \"%s\" to be not null", METHOD_NAME_PROPERTY));
            CCSMAssert.isNotNull((Object)((Object)testGapState), () -> String.format("Expected \"%s\" to be not null", TEST_GAP_STATE_PROPERTY));
            this.location = location;
            this.methodName = methodName;
            this.testGapState = testGapState;
        }

        public static TgaInformation of(@NonNull AssessedTgaData.AssessedMethodData methodData) {
            CCSMAssert.isNotNull((Object)methodData, () -> String.format("Expected \"%s\" to be not null", "methodData"));
            return new TgaInformation(methodData.getLocation(), methodData.getMethodName(), methodData.getTestGapState());
        }

        public @NonNull MethodLocation getLocation() {
            return this.location;
        }

        public @NonNull String getMethodName() {
            return this.methodName;
        }

        public @NonNull ETestGapState getTestGapState() {
            return this.testGapState;
        }
    }
}

