/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.ai.findings;

import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.index.ai.findings.FindingResolutionException;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public enum EAiFindingResolutionPromptGenerator {
    LINE_REF_WITH_DESCRIPTION{

        @Override
        public PromptGenerationResult generatePrompt(TrackedFinding finding, TokenElementInfo tokenElement, FindingTypeDescription findingDescription) throws FindingResolutionException {
            return EAiFindingResolutionPromptGenerator.extractRelevantCodeAndGeneratePrompt(finding, tokenElement, findingDescription, (language, code, lineNumber, message, description) -> "Following you find a piece of code written in " + language.getReadableName() + ", a short message of the issue, and then a longer description of the issue. Answer with an improved version of the code with the issue removed. If this is not possible or you do not know how to do it, then answer 'FAILED'. If you think this is a false positive, then answer 'FALSE_POSITIVE'. Answer only with the resulting code, which should be a full replacement of the provided code, or the single word 'FAILED' or 'FALSE_POSITIVE'. The issue is in line " + lineNumber + " of the provided code.\n\nMessage:\n" + finding.getMessage() + "\n\nDescription:\n" + findingDescription.getDescription() + "\n\nCode:\n" + code + "\n");
        }
    }
    ,
    LINE_REF_NO_DESCRIPTION{

        @Override
        public PromptGenerationResult generatePrompt(TrackedFinding finding, TokenElementInfo tokenElement, FindingTypeDescription findingDescription) throws FindingResolutionException {
            return EAiFindingResolutionPromptGenerator.extractRelevantCodeAndGeneratePrompt(finding, tokenElement, findingDescription, (language, code, lineNumber, message, description) -> "Following you find a piece of code written in " + language.getReadableName() + " and a short message of the issue Answer with an improved version of the code with the issue removed. If this is not possible or you do not know how to do it, then answer 'FAILED'. If you think this is a false positive, then answer 'FALSE_POSITIVE'. Answer only with the resulting code, which should be a full replacement of the provided code, or the single word 'FAILED' or 'FALSE_POSITIVE'. The issue is in line " + lineNumber + " of the provided code.\n\nMessage:\n" + finding.getMessage() + "\n\nCode:\n" + code + "\n");
        }
    }
    ,
    INLINE_ISSUE{

        @Override
        public PromptGenerationResult generatePrompt(TrackedFinding finding, TokenElementInfo tokenElement, FindingTypeDescription findingDescription) throws FindingResolutionException {
            return EAiFindingResolutionPromptGenerator.extractRelevantCodeAndGeneratePrompt(finding, tokenElement, findingDescription, (language, code, lineNumber, message, description) -> {
                List codeLines = StringUtils.splitLinesAsList((String)code);
                codeLines.add(lineNumber - 1, "// ISSUE: " + message.replaceAll("[\\n\\r]", " "));
                String patchedCode = StringUtils.concat((Iterable)codeLines, (String)"\n");
                return "Following you find a piece of code written in " + language.getReadableName() + ". This code contains a comment starting with the word \"ISSUE:\", followed by a short message describing the issue. Answer with an improved version of the code with the issue removed. If this is not possible or you do not know how to do it, then answer 'FAILED'. If you think this is a false positive, then answer 'FALSE_POSITIVE'. Answer only with the resulting code, which should be a full replacement of the provided code, or the single word 'FAILED' or 'FALSE_POSITIVE'.\n\n```" + patchedCode + "```";
            });
        }
    };

    public static final EAiFindingResolutionPromptGenerator DEFAULT;

    public abstract PromptGenerationResult generatePrompt(TrackedFinding var1, TokenElementInfo var2, FindingTypeDescription var3) throws FindingResolutionException;

    private static PromptGenerationResult extractRelevantCodeAndGeneratePrompt(TrackedFinding finding, TokenElementInfo tokenElement, FindingTypeDescription findingDescription, IPromptGenerationFunction generationFunction) throws FindingResolutionException {
        int startOffset;
        ElementLocation elementLocation = finding.getLocation();
        if (!(elementLocation instanceof TextRegionLocation)) {
            throw new FindingResolutionException("Finding resolution suggestion only works for findings with text region locations!");
        }
        TextRegionLocation location = (TextRegionLocation)elementLocation;
        Optional<ShallowEntity> surroundingEntity = EAiFindingResolutionPromptGenerator.findSurroundingEntity(tokenElement, location);
        if (surroundingEntity.isEmpty()) {
            String prompt = generationFunction.generate(tokenElement.getLanguage(), tokenElement.getText(), location.getRawStartLine(), finding.getMessage(), findingDescription.getDescription());
            return new PromptGenerationResult(prompt, 0, tokenElement.getText().length());
        }
        ShallowEntity outerEntity = surroundingEntity.get();
        int lineOffset = outerEntity.getStartLine();
        for (startOffset = outerEntity.getStartOffset(); startOffset > 0 && tokenElement.getText().charAt(startOffset - 1) != '\n'; --startOffset) {
        }
        int endOffset = outerEntity.getEndOffset() + 1;
        String oldMethodContent = tokenElement.getText().substring(startOffset, endOffset);
        String prompt = generationFunction.generate(tokenElement.getLanguage(), oldMethodContent, location.getRawStartLine() - lineOffset + 1, finding.getMessage(), findingDescription.getDescription());
        return new PromptGenerationResult(prompt, startOffset, endOffset);
    }

    private static @NonNull Optional<ShallowEntity> findSurroundingEntity(TokenElementInfo element, TextRegionLocation location) throws FindingResolutionException {
        Optional lineEntity = ShallowEntityTraversalUtils.findEntityForLine((int)location.getRawStartLine(), element.getRawShallowEntities());
        if (lineEntity.isEmpty()) {
            throw new FindingResolutionException("Could not determine AST node containing the finding's start line.");
        }
        Optional methodEntity = ShallowEntityTraversalUtils.findEntityOrParentEntity((ShallowEntity)((ShallowEntity)lineEntity.get()), EAiFindingResolutionPromptGenerator::isMeaningfulEntity);
        ShallowEntity outerEntity = methodEntity.orElseGet(() -> (ShallowEntity)CollectionUtils.getLast((List)ShallowEntityTraversalUtils.findMatchingParentEntities((ShallowEntity)((ShallowEntity)lineEntity.get()), x -> true)));
        if (outerEntity == null || outerEntity.getEndLine() < location.getRawEndLine()) {
            return Optional.empty();
        }
        return Optional.of(outerEntity);
    }

    private static boolean isMeaningfulEntity(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE || entity.getType() == EShallowEntityType.METHOD && !"lambda".equals(entity.getSubtype());
    }

    static {
        DEFAULT = LINE_REF_WITH_DESCRIPTION;
    }

    @FunctionalInterface
    private static interface IPromptGenerationFunction {
        public String generate(ELanguage var1, String var2, int var3, String var4, String var5);
    }

    public record PromptGenerationResult(String prompt, int replacedTextRangeStartOffset, int replacedTextRangeEndOffset) {
    }
}

